<?php
/*
 * This file is part of the Microweber framework.
 *
 * (c) Microweber CMS LTD
 *
 * For full license information see
 * https://github.com/microweber/microweber/blob/master/LICENSE
 *
 */

namespace MicroweberPackages\Order\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use MicroweberPackages\Module\Facades\ModuleManager;
use MicroweberPackages\Order\Http\Controllers\AdminOrdersController;
use MicroweberPackages\Order\OrderManager;

class OrderServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {
        /**
         * @property \MicroweberPackages\Order    $order_manager
         */
        $this->app->singleton('order_manager', function ($app) {
            return new OrderManager();
        });

        View::addNamespace('order', __DIR__ . '/../resources/views');

        //ModuleManager::register('shop/orders/manage','MicroweberPackages\Order\Http\Controllers\AdminOrdersController@index');


    }
}