<?php


if (!isset($_REQUEST['order_id'])
    and !isset($_REQUEST['payment_verify_token'])
    and !isset($_REQUEST['token'])
) {
    return;
}


// get the token from Payza
$token = "token=" . urlencode($_REQUEST['token']);

// send the URL encoded TOKEN string to the Payza's IPN handler
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://secure.payza.com/ipn2.ashx");
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $token);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

// $response holds the response string from the Payza's IPN.
$response = curl_exec($ch);

curl_close($ch);

// file_put_contents(__DIR__ . DS . 'log__resp_' . time() . '.txt', print_r($response, true));


if ($response != FALSE) {
    if (urldecode($response) == "INVALID TOKEN") {
        $update_order['is_paid'] = 0;

    } else {
        // urldecode the received response from Payza's IPN V2
        $parsedQueryString = urldecode($response);

        parse_str($parsedQueryString, $response);


        if (isset($response['order_id'])
            and isset($response['payment_verify_token'])
            and isset($response['ap_status'])
        ) {

            $query = array();
            $query['payment_verify_token'] = $response['payment_verify_token'];
            $query['id'] = $response['order_id'];
            $query['single'] = true;
            $order = mw()->shop_manager->get_orders($query);

            if ($order) {
                $update_order['transaction_id'] = $response['ap_referencenumber']; // a reference generated by the payment gateway
                $update_order['payment_amount'] = $response['ap_totalamount'];
                $update_order['payment_status'] = $response['ap_transactionstate'];

                if (isset($response['ap_currency'])) {
                    $update_order['payment_currency'] = $response['ap_currency'];
                }

                if (isset($response['ap_custemailaddress'])) {
                    $update_order['payment_email'] = $response['ap_custemailaddress'];
                }

                if (isset($response['ap_custfirstname'])) {
                    $update_order['payment_name'] = $response['ap_custfirstname'];
                    if (isset($response['ap_custlastname'])) {
                        $update_order['payment_name'] .= ' ' . $response['ap_custlastname'];
                    }
                }

                if (isset($response['ap_custcountry'])) {
                    $update_order['payment_country'] = $response['ap_custcountry'];
                }
                if (isset($response['ap_custcity'])) {
                    $update_order['payment_city'] = $response['ap_custcity'];
                }
                if (isset($response['ap_custstate'])) {
                    $update_order['payment_state'] = $response['ap_custstate'];
                }
                if (isset($response['ap_custzip'])) {
                    $update_order['payment_zip'] = $response['ap_custzip'];
                }
                if (isset($response['ap_transactiontype'])) {
                    $update_order['payment_type'] = $response['ap_transactiontype'];
                }
                if (isset($response['ap_custaddress'])) {
                    $update_order['payment_address'] = $response['ap_custaddress'];
                }




                $update_order['success'] = 'Your payment was successful! Transaction id: ' . $response['ap_referencenumber'];
                $update_order['is_paid'] = 1;
                $update_order['order_completed'] = 1;

            }

        }


    }
} else {
    // something is wrong, no response is received from Payza
}



