/*!
 * Cropper v0.4.2
 * https://github.com/fengyuanchen/cropper
 *
 * Copyright 2014 Fengyuan Chen
 * Released under the MIT license
 */

!function(a){"function"==typeof define&&define.amd?define(["jquery"],a):a(jQuery)}(function(a){"use strict";var b=a(window),c=/^(\+|\*|e|n|w|s|ne|nw|sw|se)$/i,d=/^(x|y|width|height)$/i,e="cropper-hidden",f="cropper-invisible",g=function(a){return"number"==typeof a},h=function(b,c){this.$image=a(b),this.setDefaults(c),this.init()},i=Math.round,j=Math.min,k=Math.max,l=Math.abs,m=parseFloat;h.prototype={construstor:h,setDefaults:function(b){b=a.extend({},h.defaults,b),a.each(b,function(a,c){switch(a){case"aspectRatio":b[a]=l(m(c))||0/0;break;case"minWidth":case"minHeight":b[a]=l(m(c))||0;break;case"maxWidth":case"maxHeight":b[a]=l(m(c))||1/0}}),this.defaults=b},init:function(){var b=this,c=this.$image.attr("src"),d=a('<img src="'+c+'">'),e={};this.$clone&&this.$clone.remove(),this.$clone=d,d.one("load",function(){e.naturalWidth=this.naturalWidth||d.width(),e.naturalHeight=this.naturalHeight||d.height(),e.aspectRatio=e.naturalWidth/e.naturalHeight,b.active=!0,b.src=c,b.image=e,b.build()}),d.addClass(f).prependTo("body")},build:function(){var b,c,d=this.defaults;this.built&&this.unbuild(),b=a.Event("build.cropper"),this.$image.trigger(b),b.isDefaultPrevented()||(this.$cropper=c=a(h.template),this.$image.addClass(e),this.$clone.removeClass(f).prependTo(c),this.$container=this.$image.parent(),this.$container.append(c),this.$modal=c.find(".cropper-modal"),this.$canvas=c.find(".cropper-canvas"),this.$dragger=c.find(".cropper-dragger"),this.cropped=!0,d.autoCrop||(this.$dragger.addClass(e),this.cropped=!1),this.$modal.toggleClass(e,!d.modal),!d.dragCrop&&this.$canvas.addClass(e),!d.moveable&&this.$dragger.find(".cropper-face").addClass(e),!d.resizeable&&this.$dragger.find(".cropper-line, .cropper-point").addClass(e),this.addListener(),this.initPreview(),this.built=!0,this.update(),this.$image.trigger("built.cropper"))},unbuild:function(){this.built&&(this.built=!1,this.removeListener(),this.$preview.empty(),this.$preview=null,this.$dragger=null,this.$canvas=null,this.$modal=null,this.$container=null,this.$cropper.remove(),this.$cropper=null)},update:function(a){this.initContainer(),this.initCropper(),this.initDragger(),a?this.setData(a,!0):this.setData(this.defaults.data)},show:function(){this.$cropper.removeClass(e),this.$image.addClass(e)},hide:function(){this.$cropper.addClass(e),this.$image.removeClass(e)},enable:function(){this.show()},disable:function(){this.hide()},resize:function(){clearTimeout(this.resizing),this.resizing=setTimeout(a.proxy(this.update,this,this.getData()),200)},reset:function(a){this.cropped&&(a&&(this.defaults.data={}),this.dragger=this.cloneDragger(),this.setData(this.defaults.data))},release:function(){this.cropped&&(this.cropped=!1,this.defaults.done({x:0,y:0,width:0,height:0}),this.$dragger.addClass(e))},destroy:function(){this.active&&(this.unbuild(),this.$image.removeClass(e),this.$image.removeData("cropper"),this.$image=null)},preview:function(){var b=this.cropper,c=this.dragger;this.$preview.each(function(){var d=a(this),e=d.width()/c.width,f={height:i(b.height*e),marginLeft:-i(c.left*e),marginTop:-i(c.top*e),width:i(b.width*e)};d.find("img").css(f)})},addListener:function(){var c=this.defaults;this.$image.on({"build.cropper":c.build,"built.cropper":c.built,"render.cropper":c.render}),this.$cropper.on({"mousedown touchstart":a.proxy(this.dragstart,this),"mousemove touchmove":a.proxy(this.dragmove,this),"mouseup mouseleave touchend touchleave":a.proxy(this.dragend,this)}),b.on("resize",a.proxy(this.resize,this))},removeListener:function(){var a=this.defaults;this.$image.off({"build.cropper":a.build,"built.cropper":a.built,"render.cropper":a.render}),this.$cropper.off({"mousedown touchstart":this.dragstart,"mousemove touchmove":this.dragmove,"mouseup mouseleave touchend touchleave":this.dragend}),b.off("resize",this.resize)},initPreview:function(){var a=this.defaults.preview;this.$preview=this.$cropper.find(".cropper-preview"),a&&(this.$preview=this.$preview.add(a)),this.$preview.html('<img src="'+this.src+'">')},initContainer:function(){var a=this.$container;this.container={width:a.width(),height:a.height()}},initCropper:function(){var a,b=this.container,c=this.image;c.naturalWidth*b.height/c.naturalHeight-b.width>=0?(a={height:b.width/c.aspectRatio,width:b.width,left:0},a.top=(b.height-a.height)/2):(a={height:b.height,width:b.height*c.aspectRatio,top:0},a.left=(b.width-a.width)/2),c.ratio=a.width/c.naturalWidth,c.height=a.height,c.width=a.width,this.$cropper.css({height:i(a.height),left:i(a.left),top:i(a.top),width:i(a.width)}),this.cropper=a},initDragger:function(){var a,b=this.defaults,c=this.cropper,d=b.aspectRatio||this.image.aspectRatio,e=this.image.ratio;a=c.height*d-c.width>=0?{height:c.width/d,width:c.width,left:0,top:(c.height-c.width/d)/2,maxWidth:c.width,maxHeight:c.width/d}:{height:c.height,width:c.height*d,left:(c.width-c.height*d)/2,top:0,maxWidth:c.height*d,maxHeight:c.height},b.aspectRatio?(isFinite(b.maxWidth)?(a.maxWidth=j(a.maxWidth,b.maxWidth*e),a.maxHeight=a.maxWidth/d):isFinite(b.maxHeight)&&(a.maxHeight=j(a.maxHeight,b.maxHeight*e),a.maxWidth=a.maxHeight*d),b.minWidth>0?(a.minWidth=k(0,b.minWidth*e),a.minHeight=a.minWidth/d):b.minHeight>0&&(a.minHeight=k(0,b.minHeight*e),a.minWidth=a.minHeight*d)):(a.maxWidth=j(a.maxWidth,b.maxWidth*e),a.maxHeight=j(a.maxHeight,b.maxHeight*e),a.minWidth=k(0,b.minWidth*e),a.minHeight=k(0,b.minHeight*e)),a.height*=.8,a.width*=.8,a.left=(c.width-a.width)/2,a.top=(c.height-a.height)/2,this.defaultDragger=a,this.dragger=this.cloneDragger()},cloneDragger:function(){return a.extend({},this.defaultDragger)},renderDragger:function(){var b,c=this.dragger,d=this.cropper;c.width=c.width>c.maxWidth?c.maxWidth:c.width<c.minWidth?c.minWidth:c.width,c.height=c.height>c.maxHeight?c.maxHeight:c.height<c.minHeight?c.minHeight:c.height,c.maxLeft=d.width-c.width,c.maxTop=d.height-c.height,c.left=c.left>c.maxLeft?c.maxLeft:c.left<0?0:c.left,c.top=c.top>c.maxTop?c.maxTop:c.top<0?0:c.top,b=a.Event("render.cropper"),this.$image.trigger(b),b.isDefaultPrevented()||(this.dragger=c,this.defaults.done(this.getData()),this.$dragger.css({height:i(c.height),left:i(c.left),top:i(c.top),width:i(c.width)}),this.preview())},setData:function(b,c){var d=this.cropper,e=this.dragger,f=this.defaults.aspectRatio;this.built&&"undefined"!=typeof b&&((null===b||a.isEmptyObject(b))&&(e=this.cloneDragger()),a.isPlainObject(b)&&!a.isEmptyObject(b)&&(c||(this.defaults.data=b),b=this.transformData(b),g(b.x)&&b.x<=d.width&&(e.left=b.x),g(b.y)&&b.y<=d.height&&(e.top=b.y),f?g(b.width)&&b.width<=d.width?(e.width=b.width,e.height=e.width/f):g(b.height)&&b.height<=d.height&&(e.height=b.height,e.width=e.height*f):(g(b.width)&&b.width<=d.width&&(e.width=b.width),g(b.height)&&b.height<=d.height&&(e.height=b.height))),this.dragger=e,this.renderDragger())},getData:function(){var a=this.dragger,b={};return this.built&&(b={x:a.left,y:a.top,width:a.width,height:a.height},b=this.transformData(b,!0)),b},transformData:function(b,c){var e=this.image.ratio,f={};return a.each(b,function(a,b){b=m(b),d.test(a)&&!isNaN(b)&&(f[a]=i(c?b/e:b*e))}),f},setAspectRatio:function(a){var b="auto"===a;a=m(a),(b||!isNaN(a)&&a>0)&&(this.defaults.aspectRatio=b?0/0:a,this.built&&(this.initDragger(),this.renderDragger()))},setImgSrc:function(a){a&&a!==this.src&&(this.$image.attr("src",a),this.init())},getImgInfo:function(){return this.image||{}},dragstart:function(b){var d,f,g=(b.originalEvent||b).touches,h=b;g&&1===g.length&&(h=g[0],this.touchId=h.identifier,d=!0),f=a(h.target).data("direction"),c.test(f)&&(this.direction=f,this.startX=h.pageX,this.startY=h.pageY,"+"===f&&(this.cropping=!0,this.$modal.removeClass(e)),this.$image.trigger("dragstart.cropper"),d&&b.preventDefault())},dragmove:function(a){var b,c=(a.originalEvent||a).changedTouches,d=a;c&&1===c.length&&(d=c[0],b=!0,d.identifier!==this.touchId)||this.direction&&(this.endX=d.pageX,this.endY=d.pageY,this.$image.trigger("dragmove.cropper"),b&&a.preventDefault(),this.dragging())},dragend:function(a){var b,c=(a.originalEvent||a).changedTouches,d=a;c&&1===c.length&&(d=c[0],b=!0,d.identifier!==this.touchId)||this.direction&&(this.cropping&&(this.cropping=!1,this.$modal.toggleClass(e,!this.defaults.modal)),this.direction="",this.$image.trigger("dragend.cropper"),b&&a.preventDefault())},dragging:function(){var a,b=this.direction,c=this.dragger,d=this.defaults.aspectRatio,f={x:this.endX-this.startX,y:this.endY-this.startY};switch(d&&(f.X=f.y*d,f.Y=f.x/d),b){case"+":f.x&&f.y&&(a=this.$cropper.offset(),c.left=this.startX-a.left,c.top=this.startY-a.top,c.width=0,c.height=0,this.direction=f.x>0?f.y>0?"se":"ne":f.y>0?"sw":"nw",this.cropped||(this.cropped=!0,this.$dragger.removeClass(e)));break;case"*":c.left+=f.x,c.top+=f.y;break;case"e":c.width+=f.x,d&&(c.height=c.width/d,c.top-=f.Y/2),c.width<0&&(this.direction="w",c.width=0);break;case"n":c.height-=f.y,c.top+=f.y,d&&(c.width=c.height*d,c.left+=f.X/2),c.height<0&&(this.direction="s",c.height=0);break;case"w":c.width-=f.x,c.left+=f.x,d&&(c.height=c.width/d,c.top+=f.Y/2),c.width<0&&(this.direction="e",c.width=0);break;case"s":c.height+=f.y,d&&(c.width=c.height*d,c.left-=f.X/2),c.height<0&&(this.direction="n",c.height=0);break;case"ne":c.height-=f.y,c.top+=f.y,d?c.width=c.height*d:c.width+=f.x,c.height<0&&(this.direction="sw",c.height=0,c.width=0);break;case"nw":c.height-=f.y,c.top+=f.y,d?(c.width=c.height*d,c.left+=f.X):(c.width-=f.x,c.left+=f.x),c.height<0&&(this.direction="se",c.height=0,c.width=0);break;case"sw":c.width-=f.x,c.left+=f.x,d?c.height=c.width/d:c.height+=f.y,c.width<0&&(this.direction="ne",c.height=0,c.width=0);break;case"se":c.width+=f.x,d?c.height=c.width/d:c.height+=f.y,c.width<0&&(this.direction="nw",c.height=0,c.width=0)}this.renderDragger(),this.startX=this.endX,this.startY=this.endY}},h.template=['<div class="cropper-container">','<div class="cropper-modal"></div>','<div class="cropper-canvas" data-direction="+"></div>','<div class="cropper-dragger">','<span class="cropper-preview"></span>','<span class="cropper-dashed dashed-h"></span>','<span class="cropper-dashed dashed-v"></span>','<span class="cropper-face" data-direction="*"></span>','<span class="cropper-line line-e" data-direction="e"></span>','<span class="cropper-line line-n" data-direction="n"></span>','<span class="cropper-line line-w" data-direction="w"></span>','<span class="cropper-line line-s" data-direction="s"></span>','<span class="cropper-point point-e" data-direction="e"></span>','<span class="cropper-point point-n" data-direction="n"></span>','<span class="cropper-point point-w" data-direction="w"></span>','<span class="cropper-point point-s" data-direction="s"></span>','<span class="cropper-point point-ne" data-direction="ne"></span>','<span class="cropper-point point-nw" data-direction="nw"></span>','<span class="cropper-point point-sw" data-direction="sw"></span>','<span class="cropper-point point-se" data-direction="se"></span>',"</div>","</div>"].join(""),h.defaults={aspectRatio:"auto",data:{},done:a.noop,autoCrop:!0,dragCrop:!0,modal:!0,moveable:!0,resizeable:!0,maxWidth:1/0,maxHeight:1/0,minWidth:0,minHeight:0},h.setDefaults=function(b){a.extend(h.defaults,b)},h.other=a.fn.cropper,a.fn.cropper=function(b,c){var d=this;return this.each(function(){var e=a(this),f=e.data("cropper");!f&&a.isPlainObject(b)&&e.data("cropper",f=new h(this,b)),"string"==typeof b&&a.isFunction(f[b])&&(d=f[b](c))}),"undefined"!=typeof d?d:this},a.fn.cropper.constructor=h,a.fn.cropper.setDefaults=h.setDefaults,a.fn.cropper.noConflict=function(){return a.fn.cropper=h.other,this}});