<?php

/*

type: layout

name: Related Rooms

description: Slider

*/
?>


<style>
    .slick-gallery img {
        padding: 0 6px;
    }

    .slick-gallery .slick-next {
        right: 45px;
        z-index: 99;
    }

    .slick-gallery .slick-prev {
        left: 45px;
        z-index: 99;
    }
</style>
<script>
    /* ###################### Slick   ###################### */
    $(document).ready(function () {
        if ($('<?php print '#' . $params['id']; ?> .slick-gallery').length > 0) {
            $('<?php print '#' . $params['id']; ?> .slick-gallery').each(function () {
                var el = $(this);
                el.slick({
                    centerMode: false,
                    centerPadding: '0px',
                    slidesToShow: 4,
                    arrows: false,
                    autoplay: true,
                    speed: 10000,
                    cssEase: 'linear',
                    autoplaySpeed: 0,
                    dots: false,
                    pauseOnFocus: true,
                    responsive: [
                        {
                            breakpoint: 1200,
                            settings: {
                                arrows: false,
                                slidesToShow: 3
                            }
                        }, {
                            breakpoint: 768,
                            settings: {
                                arrows: true,
                                slidesToShow: 2,
                                autoplaySpeed: 3000,
                                speed: 300,

                            }
                        }, {
                            breakpoint: 480,
                            settings: {
                                arrows: true,
                                slidesToShow: 1,
                                autoplaySpeed: 3000,
                                speed: 300,
                            }
                        }
                    ]
                });
            });
        }
    });

</script>

<?php if (!empty($data)): ?>
    <div class="slick-gallery">
        <?php foreach ($data as $item): ?>
            <div class="slide item pictures picture-<?php print $item['id']; ?>" itemscope itemtype="<?php print $schema_org_item_type_tag ?>" onclick="location.href='<?php print $item['link'] ?>';">

                <?php if (!isset($show_fields) or $show_fields == false or in_array('thumbnail', $show_fields)): ?>
                    <img src="<?php print thumbnail($item['image'], 500, 400, true); ?>" alt="">
                <?php endif; ?>
                <?php if (isset($item['title'])): ?>
                    <br/>
                    <p><?php print $item['title'] ?></p>
                <?php endif; ?>

            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
