<?php include template_dir() . "header.php"; ?>
    <script>
        $(document).ready(function () {
            $('.navigation-holder').addClass('not-transparent');
        })
    </script>

    <div class="shop-inner-page" id="shop-content-<?php print CONTENT_ID; ?>">
        <section class="p-t-100 p-b-50 fx-particles">
            <div class="container">
                <div class="row product-holder">
                    <div class="col-12 col-lg-6">
                        <module type="pictures" rel="content" template="skin-6"/>
                    </div>

                    <div class="col-12 col-lg-6 relative product-info-wrapper">
                        <div class="product-info">
                            <div class="product-info-content">
                                <div class="box">
                                    <div class="heading">
                                        <h1 class="edit" field="title" rel="content"><?php print content_title(); ?></h1>
                                    </div>

                                    <div class="row">
                                        <div class="col-12 col-md-7">
                                            <?php $content_data = content_data(CONTENT_ID);
                                            $in_stock = true;
                                            if (isset($content_data['qty']) and $content_data['qty'] != 'nolimit' and intval($content_data['qty']) == 0) {
                                                $in_stock = false;
                                            }
                                            ?>

                                            <?php if (isset($content_data['sku'])): ?>
                                                <p class="labels"><?php _e("SKU Number") ?>: <span>#<?php print $content_data['sku']; ?></span></p>
                                            <?php endif; ?>

                                            <?php if ($in_stock == true): ?>
                                                <p class="labels"><?php _e("Availability") ?>: <span><?php _e("In Stock") ?></span></p>
                                            <?php else: ?>
                                                <p class="labels"><?php _e("Availability") ?>: <span><?php _e("Out of Stock") ?></span></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-12">
                                            <div class="description">
                                                <div class="edit typography-area" field="content_body" rel="content">
                                                    <h3><?php print _lang('Description', 'templates/bamboo'); ?></h3>
                                                    <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.</p>

                                                    <h3><?php print _lang('Materials', 'templates/bamboo'); ?></h3>
                                                    <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <module type="shop/cart_add"/>

                                    <div class="edit safe-mode" field="post_share_1" rel="inherit">
                                        <div class="element">
                                            <div class="m-t-40">
                                                <module type="sharer" id="product-top-sharer"/>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="edit" field="related_products" rel="inherit">
                    <div class="row">
                        <div class="col-12">
                            <h2 class="owl-featured m-b-80"><?php print _lang('<strong>Related</strong> products:', 'templates/bamboo'); ?></h2>
                            <module type="shop/products" template="skin-1" related="true" limit="6" hide_paging="true"/>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>


<?php include template_dir() . "footer.php"; ?>