# Contributing to lcobucci/jose-parsing

First off, thanks for taking the time to contribute!

## Reporting issues

We accept bug and feature requests via issues created [here](https://github.com/lcobucci/jose-parsing/issues).

### Prior to submitting a bug report

- **Always search the issue or pull request list first** - The odds are good that if you've found a problem, someone else has found it, too;
- **Always try the [master](https://github.com/lcobucci/jose-parsing) branch** - to see if the reported bug has not already been fixed.

## Pull Requests

We accept contributions via pull requests [here](https://github.com/lcobucci/jose-parsing/pulls).

- Follow [PSR-2 coding standards](http://www.php-fig.org/psr/psr-2);
- Follow [PSR-4 autoloading standards](http://www.php-fig.org/psr/psr-4);
- Follow [semver](http://semver.org);
- Add tests (everything MUST be well tested);
- Improve documentation (don't forget to update README.md);
- Create topic branchs (don't send a PR from your master);
- One pull request per feature;
- Send coherent history by rebasing your work before submitting;

### Branches

- **master**: used to the next release
- **2.0**: used to fix bugs
- **1.0**: used to fix bugs

**Thank you and happy coding!**

@lcobucci
