<?php
use Omnipay\Omnipay;

$api_key = get_option('mollie_api_key', 'payments');


$gateway = Omnipay::create('Mollie');
$gateway->setApiKey($api_key);

 
$formData = include(dirname(__DIR__).DS.'lib'.DS.'omnipay'.DS.'omnipay_populate_form_data.php');
 
try {
    // Send purchase request
    $response = $gateway->purchase(
        array(
            'amount'   => $place_order['amount'],
            'currency' => $place_order['currency'],
			'description' => $place_order['item_name'],
			'transactionId' => $place_order['payment_verify_token'],

			
			'returnUrl' => $mw_return_url,
			'notifyUrl' => $mw_ipn_url,
			'cancelUrl' => $mw_cancel_url,
        )
    )->send();

    if ($response->isSuccessful()){
        $place_order['transaction_id'] = $response->getTransactionReference(); // a reference generated by the payment gateway
        $place_order['success'] = 'Your payment was successful! ' . $response->getMessage();
        $place_order['is_paid'] = 1;
        $place_order['order_completed'] = 1;

    } elseif ($response->isRedirect()) {
		$place_order['order_completed'] = 1;
		$place_order['is_paid'] = 0;
		$place_order['redirect'] = $response->getRedirectUrl();
		
 
       // return $response->redirect();

    } else {
        $place_order['error'] = $response->getMessage();

    }
} catch (\Omnipay\Common\Exception\InvalidCreditCardException $e) {
    $msg = $e->getMessage();

    $place_order['error'] = $msg;

} catch (\Exception $e) {
    $msg = $e->getMessage();
    $place_order['error'] = $msg;


}



//$place_order['order_completed'] = 1;
//$place_order['is_paid'] = 0;
//$place_order['success'] = _e('Thank you for your order', true);
