<?php include template_dir() . "header.php"; ?>

    <div id="blog-content-<?php print CONTENT_ID; ?>">
        <?php $post = get_content_by_id(CONTENT_ID); ?>

        <section class="iq-breadcrumb overview-block-pt text-center iq-bg iq-bg-fixed iq-over-blue-90"
                 style="background-image: url(<?php print template_url(); ?>assets/images/bg.jpg);">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="heading-title white iq-breadcrumb-title iq-mtb-100">
                            <h1 class="title iq-tw-7"><?php print content_title(); ?></h1>
                        </div>

                        <module type="breadcrumb"/>
                    </div>
                </div>
            </div>
        </section>

        <section id="blog" class="iq-page-blog overview-block-ptb">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="iq-blog-box">
                            <div class="iq-blog-image clearfix">
                                <div class="row">
                                    <div class="col-xs-12 text-center">
                                        <module type="pictures" rel="content"/>
                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="iq-blog-detail">
                                <!--                                <div class="blog-title"><a href="blog-single.html"><h5 class="iq-tw-7 iq-mb-10">Blogpost With Image</h5></a></div>-->
                                <div class="blog-content">
                                    <div class="edit dropcap" field="content" rel="content">
                                        <div class="element">
                                            <p align="justify"><?php _lang("This text is set by default and is suitable for edit in real time. By default the drag and drop core feature will allow you to position it anywhere on the site. Get creative, Make Web.", "templates/sofbox"); ?></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="iq-blog-meta">
                                    <ul class="list-inline">
                                        <?php if ($post['created_by']): ?>
                                            <li><a href="#"><i class="fa fa-user-circle"
                                                               aria-hidden="true"></i> <?php print user_name($post['created_by']); ?>
                                                </a></li>
                                        <?php endif; ?>
                                        <?php if ($post['created_at']): ?>
                                            <li><a href="#"><i class="fa fa-calendar"
                                                               aria-hidden="true"></i> <?php print date('M d, Y', strtotime($post['created_at'])); ?>
                                                </a></li>
                                        <?php endif; ?>
                                        <li><a href="#"><i class="fa fa-comment-o"
                                                           aria-hidden="true"></i> <?php print get_comments('count=1&content_id=' . content_id()) ?>
                                            </a></li>
                                    </ul>
                                </div>

                                <div id="comments" class="iq-mt-30">
                                    <h3 class="heading-left iq-tw-6 "><?php _lang("Comments", "templates/sofbox"); ?>
                                        <small>
                                            / <?php print get_comments('count=1&content_id=' . content_id()) ?></small>
                                    </h3>

                                    <module type="comments" data-content-id="<?php print CONTENT_ID; ?>"/>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>


<?php include template_dir() . "footer.php"; ?>