<!DOCTYPE html>
<html prefix="og: http://ogp.me/ns#" lang="en">

<head>

    <title>{content_meta_title}</title>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"/>
    <meta property="og:title" content="{content_meta_title}"/>
    <meta name="keywords" content="{content_meta_keywords}"/>
    <meta name="description" content="{content_meta_description}"/>
    <meta property="og:type" content="{og_type}"/>
    <meta property="og:url" content="{content_url}"/>
    <meta property="og:image" content="{content_image}"/>
    <meta property="og:description" content="{og_description}"/>
    <meta property="og:site_name" content="{og_site_name}"/>
    <script>mw.lib.require('material_icons');</script>
    <script>mw.lib.require('mw_icons_mind');</script>


    <script>
        AddToCartModalContent = window.AddToCartModalContent || function (title) {
                var html = ''
                    + '<section style="text-align: center;">'
                    + '<h5>' + title + '</h5>'
                    + '<p><?php _e("has been added to your cart"); ?></p><br />'
                    + '<div><a href="javascript:;" onclick="mw.tools.modal.remove(\'#AddToCartModal\')" class="pull-left m-t-15"><?php _e("Continue shopping"); ?></a>'
                    + '<a href="<?php print checkout_url(); ?>" class="btn-d pull-right"><?php _e("Checkout"); ?></a></section><div class="clearfix"></div></div>';
                return html;
            }

        $(document).ready(function () {
            mw.on('mw.cart.add', function (event, data) {

                if (document.getElementById('AddToCartModal') === null) {

                    AddToCartModal = mw.modal({

                        content: AddToCartModalContent(data.product.title),

                        template: 'mw_modal_basic',

                        name: "AddToCartModal",

                        width: 400,

                        height: 200

                    });

                }
                else {
                    AddToCartModal.container.innerHTML = AddToCartModalContent(data.product.title);

                }

                var currQty = parseInt($('#shopping-cart-quantity').text()) + 1;
                $('#shopping-cart-quantity').text(currQty);
            });
        });
    </script>

    <script>
        function checkFirstSectionForNav() {
            var firstSectionHas = $('.check-trasparent').first().find('.iq-bg').length > 0;
            if (firstSectionHas == true) {
                $('.main-content').removeClass('has-not-header-banner');
                // console.log('ima');
            } else {
                // console.log('nqma');
                $('.main-content').addClass('has-not-header-banner');
            }
        }

        $(document).ready(function () {
            checkFirstSectionForNav();

            $(window).on('moduleLoaded', function () {
                checkFirstSectionForNav();
            });
        });
    </script>

    <?php $color_scheme = get_option('color-scheme', 'mw-template-sofbox'); ?>
    <?php
    if (!$color_scheme) {
        $color_scheme = '';
    } else {
        $color_scheme = '-' . $color_scheme;
    }
    ?>


    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800&amp;Raleway:300,400,500,600,700,800,900" rel="stylesheet">
    <!-- Bootstrap -->
    <link rel="stylesheet" href="{TEMPLATE_URL}assets/css/bootstrap.min.css">
    <!-- owl-carousel -->
    <link rel="stylesheet" type="text/css" href="{TEMPLATE_URL}assets/css/owl-carousel/owl.carousel.css"/>
    <!-- Font Awesome -->
    <link rel="stylesheet" type="text/css" href="{TEMPLATE_URL}assets/css/font-awesome.css"/>
    <!-- Magnific Popup -->
    <link rel="stylesheet" type="text/css" href="{TEMPLATE_URL}assets/css/magnific-popup/magnific-popup.css"/>
    <!-- Animate -->
    <link rel="stylesheet" type="text/css" href="{TEMPLATE_URL}assets/css/animate.css"/>
    <!-- Ionicons -->
    <link rel="stylesheet" href="{TEMPLATE_URL}assets/css/ionicons.min.css">
    <!-- Style -->
    <link rel="stylesheet" href="{TEMPLATE_URL}assets/css/style.css">
    <!-- Responsive -->
    <link rel="stylesheet" href="{TEMPLATE_URL}assets/css/responsive.css">
    <!-- custom style -->
    <link rel="stylesheet" href="{TEMPLATE_URL}assets/css/custom.css"/>

    <!--    <link href="{TEMPLATE_URL}assets/css/color/--><?php //print $color_scheme; ?><!--.css" id="theme-color" rel="stylesheet" type="text/css" media="all"/>-->
</head>

<?php $preloader = get_option('preloader', 'mw-template-sofbox'); ?>
<?php $header_style = get_option('header-style', 'mw-template-sofbox'); ?>
<?php $shopping_cart = get_option('shopping-cart', 'mw-template-sofbox'); ?>
<?php $profile_link = get_option('profile-link', 'mw-template-sofbox'); ?>
<body data-spy="scroll" data-offset="80" class="<?php print helper_body_classes(); ?>">
<module type="template_settings" id="mw-template-sofbox"/>

<div class="main-content">

    <?php if ($preloader != '' AND $preloader == 'true'): ?>
        <div id="loading">
            <div id="loading-center">
                <div class="loader">
                    <div class="cube">
                        <div class="sides">
                            <div class="top"></div>
                            <div class="right"></div>
                            <div class="bottom"></div>
                            <div class="left"></div>
                            <div class="front"></div>
                            <div class="back"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if ($header_style == '' OR $header_style == 'style-1'): ?>
        <header id="header-wrap">
            <div class="navbar navbar-default navbar-fixed-top menu-top">
                <div class="container-fluid">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <module type="logo" id="header-logo"/>
                    </div>
                    <div class="navbar-collapse collapse">
                        <?php if ($shopping_cart == 'true'): ?>
                            <a href="<?php print checkout_url(); ?>" class="button bt-black pull-right visible-lg" style="<?php if ($profile_link == 'true'): ?>margin-left: 10px;<?php endif; ?>">
                                <i class="fa fa-shopping-cart"></i>
                                <span class="btn-xs">(<span id="shopping-cart-quantity"><?php print cart_sum(false); ?></span>)</span>
                            </a>
                        <?php endif; ?>
                        <?php if ($profile_link == 'true'): ?>
                            <a href="<?php print profile_url(); ?>" class="button bt-black pull-right visible-lg"><i class="fa fa-user"></i></a>
                        <?php endif; ?>
                        <nav>
                            <module type="menu" template="navbar"/>
                        </nav>
                    </div>
                </div>
            </div>
        </header>
    <?php elseif ($header_style == 'style-2'): ?>
        <header id="header-wrap">
            <div class="navbar navbar-default navbar-fixed-top menu-top">
                <div class="container">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <module type="logo" id="header-logo"/>
                    </div>
                    <div class="navbar-collapse collapse">
                        <?php if ($shopping_cart == 'true'): ?>
                            <a href="<?php print checkout_url(); ?>" class="button bt-black pull-right visible-lg" style="<?php if ($profile_link == 'true'): ?>margin-left: 10px;<?php endif; ?>">
                                <i class="fa fa-shopping-cart"></i>
                                <span class="btn-xs">(<span id="shopping-cart-quantity"><?php print cart_sum(false); ?></span>)</span>
                            </a>
                        <?php endif; ?>
                        <?php if ($profile_link == 'true'): ?>
                            <a href="<?php print profile_url(); ?>" class="button bt-black pull-right visible-lg"><i class="fa fa-user"></i></a>
                        <?php endif; ?>
                        <nav>
                            <module type="menu" template="navbar"/>
                        </nav>
                    </div>
                </div>
            </div>
        </header>
    <?php endif; ?>
