<?php include template_dir() . "header.php"; ?>

    <div class="shop-inner-page" id="shop-content-<?php print CONTENT_ID; ?>">
        <section class="p-t-100 p-b-50 fx-particles">
            <div class="container">
                <div class="row product-holder">
                    <div class="col-12 col-lg-6">
                        <module type="pictures" rel="content" template="skin-6"/>
                    </div>

                    <div class="col-12 col-lg-6 relative product-info-wrapper">
                        <div class="product-info">
                            <div class="product-info-content">
                                <div class="box">
                                    <div class="heading">
                                        <h1 class="edit" field="title" rel="content"><?php print content_title(); ?></h1>
                                    </div>

                                    <div class="row">
                                        <div class="col-12 col-md-7">
                                            <p class="price"><?php print currency_format(get_product_price()); ?></p>
                                        </div>
                                        <div class="col-12 col-md-7">
                                            <?php $content_data = content_data(CONTENT_ID);
                                            $in_stock = true;
                                            if (isset($content_data['qty']) and $content_data['qty'] != 'nolimit' and intval($content_data['qty']) == 0) {
                                                $in_stock = false;
                                            }
                                            ?>

                                            <?php if (isset($content_data['sku'])): ?>
                                                <p class="labels"><?php _e("SKU Number") ?>: <span>#<?php print $content_data['sku']; ?></span></p>
                                            <?php endif; ?>

                                            <?php if ($in_stock == true): ?>
                                                <p class="labels">Availability: <span><?php _e("In Stock") ?></span></p>
                                            <?php else: ?>
                                                <p class="labels">Availability: <span><?php _e("Out of Stock") ?></span></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <div class="description">
                                        <div class="edit" field="short_description" rel="content">
                                            <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.</p>
                                        </div>
                                    </div>

                                    <module type="shop/cart_add"/>



                                    <div class="edit safe-mode" field="post_share_1" rel="inherit">
                                        <div class="element">
                                            <div class="m-t-40">
                                                <module type="sharer" id="product-top-sharer"/>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <div class="product-specifications">
                                            <div class="left-side">
                                                <i class="mw-micon-solid-Chip"></i>
                                            </div>

                                            <div class="right-side">
                                                <h3><?php print _lang('Product Specifications', 'templates/active'); ?></h3>

                                                <div class="edit" field="content_body" rel="content">
                                                    <p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.</p>
                                                </div>

                                                <div class="edit" field="product_sheets" rel="content">
                                                    <div class="table-responsive m-t-20 element">
                                                        <table class="table table-striped">
                                                            <tr>
                                                                <th>Processor</th>
                                                                <th>Memory</th>
                                                                <th>Time to use</th>
                                                            </tr>
                                                            <tr>
                                                                <td>CPU 2 x 2GB</td>
                                                                <td>2 x 64GB</td>
                                                                <td>20,000 Hours</td>
                                                            </tr>
                                                            <tr>
                                                                <td>CPU 2 x 4GB</td>
                                                                <td>2 x 128GB</td>
                                                                <td>40,000 Hours</td>
                                                            </tr>
                                                            <tr>
                                                                <td>CPU 2 x 6GB</td>
                                                                <td>2 x 256GB</td>
                                                                <td>80,000 Hours</td>
                                                            </tr>
                                                            <tr>
                                                                <td>CPU 2 x 8GB</td>
                                                                <td>2 x 512GB</td>
                                                                <td>120,00 Hours</td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <module type="comments" template="skin-2"/>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <module type="layouts" template="skin-20"/>
    </div>


<?php include template_dir() . "footer.php"; ?>