<?php
header("Content-type: text/css; charset: UTF-8");

/* Convert hexdec color string to rgb(a) string */

function hex2rgba($color, $opacity = false)
{

    $default = 'rgb(0,0,0)';

    //Return default if no color provided
    if (empty($color))
        return $default;

    //Sanitize $color if "#" is provided
    if ($color[0] == '#') {
        $color = substr($color, 1);
    }

    //Check if color has 6 or 3 characters and get values
    if (strlen($color) == 6) {
        $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
    } elseif (strlen($color) == 3) {
        $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
    } else {
        return $default;
    }

    //Convert hexadec to rgb
    $rgb = array_map('hexdec', $hex);

    //Check if opacity is set(rgba or rgb)
    if ($opacity) {
        if (abs($opacity) > 1)
            $opacity = 1.0;
        $output = 'rgba(' . implode(",", $rgb) . ',' . $opacity . ')';
    } else {
        $output = 'rgb(' . implode(",", $rgb) . ')';
    }

    //Return rgb(a) color string
    return $output;
}


if (isset($_GET['color1']) AND $_GET['color1'] != '') {
    $color1 = $_GET['color1'];
} else {
    $color1 = '2af598';
}

if (isset($_GET['color2']) AND $_GET['color2'] != '') {
    $color2 = $_GET['color2'];
} else {
    $color2 = '009efd';
}

if (isset($_GET['color3']) AND $_GET['color3'] != '') {
    $color3 = $_GET['color3'];
} else {
    $color3 = 'ffffff';
}

$color1_rgb = hex2rgba($color1);
$color1_rgb = str_replace('rgb(', '', $color1_rgb);
$color1_rgb = str_replace(')', '', $color1_rgb);

$color2_rgb = hex2rgba($color2);
$color2_rgb = str_replace('rgb(', '', $color2_rgb);
$color2_rgb = str_replace(')', '', $color2_rgb);

$color3_rgb = hex2rgba($color3);
$color3_rgb = str_replace('rgb(', '', $color3_rgb);
$color3_rgb = str_replace(')', '', $color3_rgb);

$color1 = '#' . $color1;
$color2 = '#' . $color2;
$color3 = '#' . $color3;
?>

<style>
    body {
        color: #666666;
    }

    a, .button {
        color: #333333;
    }

    a:focus, a:hover {
        color: <?php print $color2; ?>;
    }

    a, .button, input {
        color: <?php print $color2; ?>;
    }

    h1, h2, h3, h4, h5, h6 {
        color: #333333;
    }

    hr {
        border-bottom: 1px solid #e0e0e0;
    }

    label {
        color: #aaaaaa;
    }

    .label {
        color: <?php print $color3; ?> !important;
    }

    blockquote {
        border-left: 5px solid<?php print $color2; ?>;
    }

    *::-moz-selection {
        background: <?php print $color2; ?>;
        color: <?php print $color3; ?>;
    }

    ::-moz-selection {
        background: <?php print $color2; ?>;
        color: <?php print $color3; ?>;
    }

    ::selection {
        background: <?php print $color2; ?>;
        color: <?php print $color3; ?>;
    }

    #back-to-top .top {
        color: <?php print $color3; ?>;
        background: #333333;
    }

    #back-to-top .top:hover {
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
        color: <?php print $color3; ?>;
    }

    .cube .sides * {
        background-color: rgba(74, 196, 243, 0.8);
        border: 5px solid white;
    }

    .button {
        color: <?php print $color3; ?>;
        background-image: linear-gradient(to right, <?php print $color1; ?> 0%, <?php print $color2; ?> 51%, <?php print $color1; ?> 100%);
    }

    .button:hover, .button:focus {
        color: <?php print $color3; ?>;
        background-position: right center;
    }

    /* Buttons white */
    .button.bt-white {
        color: #333;
        background: <?php print $color3; ?>;
    }

    .button.bt-white:hover, .button.bt-white:focus {
        color: <?php print $color3; ?>;
        background: #333;
    }

    /* Buttons white 2 */
    .button.bt-black {
        color: #333;
        background: <?php print $color3; ?>;
    }

    .button.bt-black:hover, .button.bt-black:focus {
        color: <?php print $color3; ?>;
        background: #333;
    }

    .iq-font-blue {
        color: <?php print $color2; ?>;
    }

    .iq-font-white {
        color: <?php print $color3; ?>;
    }

    .iq-font-black {
        color: #333333;
    }

    .iq-font-light {
        color: #666666;
    }

    .white-bg {
        background: <?php print $color3; ?>;
    }

    .grey-bg {
        background: #f5f7fb;
    }

    .blue-bg {
        background: <?php print $color2; ?>;
    }

    .iq-over-blue-80:before {
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 0.8) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 0.8)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 0.8) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 0.8) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 0.8) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 0.8) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    .iq-over-blue-90:before {
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 0.9) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 0.9)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 0.9) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 0.9) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 0.9) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 0.9) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    .iq-over-black-80:before {
        background: rgba(0, 0, 0, 0.8);
    }

    .iq-over-black-90:before {
        background: rgba(0, 0, 0, 0.9);
    }

    .heading-title .title:before {
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    /* Header sticky */
    header .menu-sticky {
        -webkit-box-shadow: 0px 0px 30px 0px rgba(0, 0, 0, 0.1);
        -moz-box-shadow: 0px 0px 30px 0px rgba(0, 0, 0, 0.1);
        box-shadow: 0px 0px 30px 0px rgba(0, 0, 0, 0.1);
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    .iq-banner .iq-video {
        background: <?php print $color3; ?>;
        color: <?php print $color2; ?>;
    }

    .iq-works-box {
        border: 1px solid #f7f7f7;
        -webkit-box-shadow: 0px 4px 8px 0px rgba(0, 0, 0, 0.08);
        -moz-box-shadow: 0px 4px 8px 0px rgba(0, 0, 0, 0.08);
        box-shadow: 0px 4px 8px 0px rgba(0, 0, 0, 0.08);
    }

    .iq-works-box .icon-bg {
        background: rgba(31, 76, 255, 0.1);
    }

    .iq-works-box .icon-bg i {
        color: <?php print $color2; ?>;
    }

    .iq-works-box .step {
        background: <?php print $color3; ?>;
        border: 1px solid #f7f7f7;
        color: <?php print $color2; ?>;
    }

    .iq-objects .iq-objects-04 {
        border: 56px solid<?php print $color1; ?>;
    }

    .iq-objects-software .iq-objects-03 {
        border: 40px solid<?php print $color1; ?>;
    }

    .iq-amazing-tab .nav.nav-tabs {
        border-bottom: 1px solid #e9e9e9;
    }

    .iq-amazing-tab .nav.nav-tabs li a {
        color: #666666;
    }

    .iq-amazing-tab .nav.nav-tabs li a:hover {
        color: <?php print $color2; ?>;
    }

    .iq-amazing-tab .nav.nav-tabs li a:hover i {
        color: <?php print $color2; ?>;
    }

    .iq-amazing-tab .nav.nav-tabs li.active1 a, .iq-amazing-tab .nav.nav-tabs li.active1 a:hover, .iq-amazing-tab .nav.nav-tabs li.active1 a:focus {
        color: #333333;
    }

    .iq-amazing-tab .nav.nav-tabs li.active1 a i, .iq-amazing-tab .nav.nav-tabs li.active1 a:hover i, .iq-amazing-tab .nav.nav-tabs li.active1 a:focus i {
        color: <?php print $color1; ?>;
    }

    .iq-amazing-tab .nav.nav-tabs li a:before, .iq-amazing-tab .nav.nav-tabs li a:hover:before, .iq-amazing-tab .nav.nav-tabs li a:focus:before {
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    .iq-fancy-box {
        background: <?php print $color3; ?>;
        border: 1px solid #f2f2f2;
    }

    .iq-fancy-box .iq-icon {
        color: <?php print $color2; ?>;
        background: #f4f4f4;
    }

    .iq-fancy-box:hover .iq-icon {
        color: #f4f4f4;
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    .counter-info .iq-video {
        background: <?php print $color3; ?>;
        color: <?php print $color2; ?>;
    }

    .iq-client {
        border: 1px solid #f2f2f2;
        -webkit-box-shadow: 0px 6px 16px 0px rgba(0, 0, 0, 0.06);
        -moz-box-shadow: 0px 6px 16px 0px rgba(0, 0, 0, 0.06);
        box-shadow: 0px 6px 16px 0px rgba(0, 0, 0, 0.06);
    }

    .iq-client:before {
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    .client-name:before {
        color: #f0f0f0;
    }

    .client-name:after {
        color: #f0f0f0;
    }

    .owl-carousel .owl-nav i {
        color: <?php print $color3; ?>;
        background: #e7e7e7;
    }

    .owl-carousel .owl-nav i:hover {
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
        color: <?php print $color3; ?>;
    }

    .iq-team .share ul li a {
        color: <?php print $color3; ?>;
        background: #333;
        color: <?php print $color3; ?>;
    }

    .iq-team .share ul li a:hover {
        background: <?php print $color2; ?>;
    }

    .iq-team .iq-team-img:before {
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(74, 196, 243, 0.05) 100%);
        background: -webkit-gradient(left bottom, right top, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(74, 196, 243, 0.05)));
        background: -webkit-linear-gradient(45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(74, 196, 243, 0.05) 100%);
        background: -o-linear-gradient(45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(74, 196, 243, 0.05) 100%);
        background: -ms-linear-gradient(45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(74, 196, 243, 0.05) 100%);
        background: linear-gradient(45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(74, 196, 243, 0.05) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#0028ff', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    .iq-progress-bar-text {
        color: <?php print $color2; ?>;
    }

    .iq-progress-bar-text span {
        background: <?php print $color3; ?>;
    }

    .iq-progress-bar-text span:before {
        border-color: <?php print $color3; ?> transparent transparent transparent;
    }

    .iq-progress-bar {
        background: <?php print $color3; ?> none repeat scroll 0 0;

    }

    .iq-progress-bar > span {
        background: #333 none repeat scroll 0 0;
    }

    .iq-accordion .ad-title {
        color: #2c3e50;
    }

    .iq-accordion .ad-title:before {
        -webkit-box-shadow: 0px 5px 15px 0px rgba(0, 0, 0, 0.06);
        -moz-box-shadow: 0px 5px 15px 0px rgba(0, 0, 0, 0.06);
        box-shadow: 0px 5px 15px 0px rgba(0, 0, 0, 0.06);
        color: <?php print $color3; ?>;
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    .iq-accordion .ad-details {
        color: #666666;
        border: 1px solid #eeeeee;
        -webkit-box-shadow: 0px 0px 16px 0px rgba(0, 0, 0, 0.06);
        -moz-box-shadow: 0px 0px 16px 0px rgba(0, 0, 0, 0.06);
        box-shadow: 0px 0px 16px 0px rgba(0, 0, 0, 0.06);
    }

    .iq-objects-asked .iq-objects-03 {
        border: 25px solid<?php print $color1; ?>;
    }

    .iq-blog-box {
        -webkit-box-shadow: 0px 0px 10px 0px rgba(0, 0, 0, 0.06);
        -moz-box-shadow: 0px 0px 10px 0px rgba(0, 0, 0, 0.06);
        box-shadow: 0px 0px 10px 0px rgba(0, 0, 0, 0.06);
    }

    .iq-blog-detail {
        background: <?php print $color3; ?>;
    }

    .iq-blog-detail a, .iq-blog-detail .blog-title a h5 {
        color: #333;
    }

    .iq-blog-detail a:hover, .iq-blog-detail .blog-title a:hover h5 {
        color: <?php print $color2; ?>;
    }

    .iq-footer-box .iq-icon i {
        color: <?php print $color2; ?>;
    }

    .info-share li a {
        color: #666;
        border: 1px solid #666;
    }

    .info-share li a:hover {
        background: <?php print $color2; ?>;
        border-color: <?php print $color2; ?>;
        color: <?php print $color3; ?>;
    }

    .footer-copyright {
        border-top: 1px solid #efefef;
    }

    .iq-get-in {
        -webkit-box-shadow: 0px 4px 8px 0px rgba(0, 0, 0, 0.08);
        -moz-box-shadow: 0px 4px 8px 0px rgba(0, 0, 0, 0.08);
        box-shadow: 0px 4px 8px 0px rgba(0, 0, 0, 0.08);
    }

    .contact-form .section-field input {
        color: #b6b6b6;
        border: 1px solid #e1e1e1;
    }

    .contact-form .section-field input:focus, .contact-form .section-field.textarea textarea:focus {
        border: 1px solid<?php print $color2; ?>;
    }

    .contact-form .section-field.textarea textarea {
        color: #b6b6b6;
        border: 1px solid #e1e1e1;
    }

    .contact-info:before {
        background: #e5e5e5;
    }

    .info-share li a {
        color: #666;
        border: 1px solid #666;
    }

    .info-share li a:hover {
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
        border-color: <?php print $color2; ?>;
        color: <?php print $color3; ?>;
    }

    .iq-breadcrumb .breadcrumb li a {
        color: #2c3e50;
    }

    .iq-breadcrumb .breadcrumb li a:hover {
        color: <?php print $color2; ?>;
    }

    .iq-breadcrumb .breadcrumb li {
        color: #2c3e50;
    }

    .iq-breadcrumb .breadcrumb li.active {
        color: <?php print $color2; ?>;
    }

    .iq-breadcrumb .breadcrumb > li + li:before {
        color: #2c3e50;
    }

    .pagination li a {
        color: #666;
    }

    .pagination li a:focus, .pagination li a:hover, .pagination li span:focus, .pagination li span:hover {
        border-color: #333333;
        background-color: #333333;
        color: <?php print $color3; ?>;
    }

    .pagination > .active > a, .pagination > .active > a:focus, .pagination > .active > a:hover, .pagination > .active > span, .pagination > .active > span:focus, .pagination > .active > span:hover {
        background-color: <?php print $color2; ?>;
        border-color: <?php print $color2; ?>;
        color: <?php print $color3; ?>;
    }

    .iq-comment-list .iq-comment-metadata a {
        color: #333333;
    }

    .iq-comment-list .iq-comment-metadata i {
        color: <?php print $color2; ?>;
    }

    .iq-comment-list .iq-comments-media .iq-comments-info .reply {
        color: <?php print $color3; ?>;
    }

    .iq-widget-menu ul li a {
        color: #2c3e50;
    }

    .iq-widget-menu ul li a span:hover {
        color: <?php print $color2; ?>;
    }

    .iq-widget-menu ul li.hover a {
        color: <?php print $color2; ?>;
    }

    .iq-widget-menu ul li.hover a span {
        color: <?php print $color2; ?>;
    }

    .iq-widget-menu ul ul li a span {
        color: #333333;
    }

    .iq-widget-menu ul ul li a span:hover {
        color: <?php print $color2; ?>;
    }

    .iq-widget-menu ul ul a {
        color: #333333;
    }

    .iq-widget-menu ul ul a:hover {
        color: <?php print $color2; ?>;
    }

    .iq-sidebar-widget .iq-widget-search input {
        color: #2c3e50;
        border: 2px solid #f2f2f2;
        background: <?php print $color3; ?>;
    }

    .iq-sidebar-widget .iq-widget-search input:focus {
        background: <?php print $color3; ?>;
    }

    .iq-sidebar-widget .iq-widget-search i {
        color: <?php print $color2; ?>;
    }

    .iq-sidebar-widget .iq-widget-search input:focus {
        border-color: <?php print $color2; ?>;
    }

    .iq-sidebar-widget .iq-recent-post .media-body > a {
        color: #2c3e50;
    }

    .iq-sidebar-widget .iq-recent-post .media-body > a:hover {
        color: <?php print $color2; ?>;
    }

    .iq-sidebar-widget .iq-recent-post .media-body span {
        color: #666666;
    }

    .iq-sidebar-widget .iq-recent-post .media-body span .fa {
        color: #333333;
    }

    .iq-tags li a {
        color: #666;
        border: 1px solid #666;
    }

    .iq-tags li a:hover {
        border-color: <?php print $color2; ?>;
        color: <?php print $color2; ?>;
    }

    .iq-widget-archives li a {
        color: #666;
    }

    .iq-widget-archives li a:hover {
        color: <?php print $color2; ?>;
    }

    .iq-error .big-text {
        color: #333333;
    }

    .iq-error h6 {
        background-color: <?php print $color2; ?>;
        color: <?php print $color3; ?>;
    }

    .iq-coming .big-text {
        color: #333333;
    }

    .iq-coming .countdown-timer .timer .timer-wrapper .time {
        color: #333;
    }

    #countdown li p {
        color: #a7abb1;
    }

    header .navbar-default.has-not-header-banner {
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
    }

    /*header .navbar-default .navbar-nav > li > a {*/
    /*    color: */<?php //print $color3; ?>/*;*/
    /*}*/

    header .navbar-default .navbar-nav > li > a:hover,
    header .navbar-default .navbar-nav > li > a:focus,
    header .navbar-default .navbar-nav > li.active > a,
    header .navbar-default .navbar-nav > li.active > a:focus,
    header .navbar-default .navbar-nav > li.active > a:hover {
        color: rgba(<?php print $color3_rgb; ?>, 0.7);
    }

    header .nav > li a::before {
        background: rgba(<?php print $color3_rgb; ?>, 0.7);

    }

    .btn-d {
        color: <?php print $color3; ?> !important;
        background-image: linear-gradient(to right, <?php print $color1; ?> 0%, <?php print $color2; ?> 51%, <?php print $color1; ?> 100%);
    }

    .btn-d:hover, .btn-d:focus {
        color: <?php print $color3; ?>;
        background-position: right center;
    }

    .boots-form .btn,
    .form-control .btn {
        color: <?php print $color3; ?> !important;
        background-image: linear-gradient(to right, <?php print $color1; ?> 0%, <?php print $color2; ?> 51%, <?php print $color1; ?> 100%);
    }

    .boots-form .btn:hover, .boots-form .btn:focus,
    .form-control .btn:hover, .form-control .btn:focus
    {
        color: <?php print $color3; ?>;
        background-position: right center;
    }

    .slider-container .slider-right,
    .slider-container .slider-left{
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    .has-not-header-banner header .navbar-default {
        background: rgba(<?php print $color1_rgb; ?>, 1);
        background: -moz-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -webkit-gradient(left top, right bottom, color-stop(0%, rgba(<?php print $color1_rgb; ?>, 1)), color-stop(100%, rgba(<?php print $color2_rgb; ?>, 1)));
        background: -webkit-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -o-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: -ms-linear-gradient(-45deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        background: linear-gradient(135deg, rgba(<?php print $color1_rgb; ?>, 1) 0%, rgba(<?php print $color2_rgb; ?>, 1) 100%);
        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='<?php print $color1; ?>', endColorstr='<?php print $color2; ?>', GradientType=1);
    }

    .product-price{
        color: <?php print $color2; ?>;
    }

    .module .pagination > li > a.active {
        color: <?php print $color2; ?>;
    }

    .mw-add-to-cart-holder .mw-ui-label{
        /*color: */<?php //print $color2; ?>/*;*/
    }

    .product-price-val{
        color: <?php print $color2; ?>;
    }

    .mw-ui-check span:first-of-type{
        color:  <?php print $color1; ?>;
    }

    .navbar-default .navbar-brand {
        color: <?php print $color3; ?>;
    }

    .navbar-nav .dropdown-menu>li>a{
        color: <?php print $color2; ?>;
    }


    .navbar-nav .dropdown-menu>.active>a,
    .navbar-nav .dropdown-menu>.active>a:hover,
    .navbar-nav .dropdown-menu>.active>a:focus{
        background-color: <?php print $color2; ?>;
        color: <?php print $color3; ?>;
    }
</style>