<?php
/*

  type: layout

  name: Skin-2

  description: One column

 */
?>

<div class="row">
    <?php if (!empty($data)): ?>
        <?php foreach ($data as $key => $item): ?>
            <div class="<?php if ($key > 0): ?>iq-mt-60<?php endif; ?>" itemscope itemtype="<?php print $schema_org_item_type_tag ?>">
                <div class="iq-blog-box">
                    <?php if (!isset($show_fields) or $show_fields == false or in_array('thumbnail', $show_fields)): ?>
                        <div class="iq-blog-image clearfix">
                            <a href="<?php print $item['link'] ?>" itemprop="url">
                                <img class="img-responsive center-block" src="<?php print thumbnail($item['image'], 800, 541, true); ?>" alt="<?php print $item['title'] ?>">
                            </a>
                        </div>
                    <?php endif; ?>
                    <div class="iq-blog-detail">
                        <?php if (!isset($show_fields) or $show_fields == false or in_array('title', $show_fields)): ?>
                            <div class="blog-title"><a href="<?php print $item['link'] ?>" itemprop="url"><h5 class="iq-tw-6 iq-mb-10"><?php print $item['title'] ?></h5></a></div>
                        <?php endif; ?>

                        <?php if (!isset($show_fields) or $show_fields == false or in_array('description', $show_fields)): ?>
                            <div class="blog-content">
                                <p itemprop="description"><?php print $item['description'] ?></p>
                            </div>
                        <?php endif; ?>

                        <div class="iq-blog-meta">
                            <ul class="list-inline">
                                <?php if (!isset($show_fields) or $show_fields == false or in_array('created_by', $show_fields)): ?>
                                    <li><a href="#"><i class="fa fa-user-circle" aria-hidden="true"></i> <?php print user_name($item['created_by']) ?></a></li>
                                <?php endif; ?>
                                <?php if (!isset($show_fields) or $show_fields == false or in_array('created_at', $show_fields)): ?>
                                    <li><a href="#"><i class="fa fa-calendar" aria-hidden="true"></i> <?php print date('M d, Y', strtotime($item['created_at'])); ?></a></li>
                                    <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<?php if (isset($pages_count) and $pages_count > 1 and isset($paging_param)): ?>
    <?php print paging("num={$pages_count}&paging_param={$paging_param}&current_page={$current_page}") ?>
<?php endif; ?>
