<?php include template_dir() . "header.php"; ?>


    <div id="shop-content-<?php print CONTENT_ID; ?>">
        <section class="iq-breadcrumb overview-block-pt text-center iq-bg iq-bg-fixed iq-over-blue-90"
                 style="background-image: url(<?php print template_url(); ?>assets/images/bg.jpg);">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="heading-title white iq-breadcrumb-title iq-mtb-100">
                            <h1 class="title iq-tw-7 edit" field="title"
                                rel="content"><?php print content_title(); ?></h1>
                        </div>

                        <module type="breadcrumb"/>
                    </div>
                </div>
            </div>
        </section>


        <section>
            <div class="container">
                <div class="row">
                    <div class="col-sm-12 m-t-70 m-b-70">
                        <module type="pictures" rel="content"/>
                    </div>


                    <div class="col-md-8 ">
                        <h6><?php _e('Description'); ?></h6><br />
                        <div class="edit" field="content_body" rel="content">
                            <p>
                                <?php _lang("Strategy gamification alpha startup angel investor channels customer direct mailing burn rate churn rate bandwidth innovator seed round. Ramen
                                            disruptive
                                            graphical user interface. Infrastructure bootstrapping branding leverage twitter channels MVP iPad launch party non-disclosure agreement. Infrastructure
                                            validation android release success.", "templates/sofbox"); ?>
                            </p>
                        </div>
                        <br/>
                        <br/>
                        <h6><?php _e('Specifications'); ?></h6>
                        <div class="item__description">
                            <div class="edit" field="product_sheets" rel="content">
                                <div class="table-responsive">
                                    <table class="table table-hover item__subinfo">
                                        <thead>
                                        <tr>
                                            <th><?php _lang("Column name", "templates/sofbox"); ?></th>
                                            <th><?php _lang("Column name", "templates/sofbox"); ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td><?php _lang("Size", "templates/sofbox"); ?></td>
                                            <td>2XL</td>
                                        </tr>
                                        <tr>
                                            <td><?php _lang("Color", "templates/sofbox"); ?></td>
                                            <td>Red</td>
                                        </tr>
                                        <tr>
                                            <td><?php _lang("Weight", "templates/sofbox"); ?></td>
                                            <td>132lbs</td>
                                        </tr>
                                        <tr>
                                            <td><?php _lang("Height", "templates/sofbox"); ?></td>
                                            <td>74cm</td>
                                        </tr>
                                        <tr>
                                            <td><?php _lang("Bluetooth", "templates/sofbox"); ?></td>
                                            <td>
                                                <i class="fa fa-check text-success"></i> <?php _lang("YES", "templates/sofbox"); ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><?php _lang("Wi-Fi", "templates/sofbox"); ?></td>
                                            <td>
                                                <i class="fa fa-remove text-danger"></i> <?php _lang("NO", "templates/sofbox"); ?>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="clearfix" style="margin-bottom: 30px;">
                            <?php $content_data = content_data(CONTENT_ID);
                            $in_stock = true;
                            if (isset($content_data['qty']) and $content_data['qty'] != 'nolimit' and intval($content_data['qty']) == 0) {
                                $in_stock = false;
                            }
                            ?>

                            <?php if (isset($content_data['sku'])): ?>
                                <strong><?php _e("SKU") ?>:</strong> <?php print $content_data['sku']; ?>
                            <?php endif; ?>

                            <?php if ($in_stock == true): ?>
                                <span class="text-success"><i class="fa fa-check"></i> <?php _e("In Stock") ?></span>
                            <?php else: ?>
                                <span class="text-danger"><i
                                            class="glyphicon glyphicon-remove"></i> <?php _e("Out of Stock") ?></span>
                            <?php endif; ?>
                        </div>
                        <div>
                            <module type="shop/cart_add"/>
                        </div>
                    </div>

                </div>
            </div>
        </section>

        <section>
            <div class="container">
                <div class="row">
                    <div class="iq-works-box text-left m-40 boots-form">
                        <h4 class="m-b-20"><?php _e('Related Products'); ?></h4>

                        <module type="shop/products" template="skin-1" related="true" limit="4"/>
                    </div>
                </div>
            </div>
        </section>

    </div>

<?php include template_dir() . "footer.php"; ?>