<?php


/*



type: layout



name: Small



description: Small cart template



*/

?>

<?php
$total_qty = 0;
$total_price = 0;
if ($data) {
    foreach ($data as $item) {
        $total_qty += $item['qty'];
        $total_price += $item['price'] * $item['qty'];
    }
}
?>


<h4><?php _e('Shop Cart'); ?></h4>

<div class="quick-cart-wrapper">
    <?php if ($data): ?>
        <?php foreach ($data as $item) : ?>
            <a href="<?php print($item['url']); ?>">
                <img src="<?php print thumbnail($item['picture'], 45); ?>" width="45" height="45" alt=""/>
                <h6><span><?php print $item['qty']; ?>x</span> <?php print $item['title']; ?></h6>
                <small><?php print currency_format($item['price']); ?></small>
            </a>
            <a href="javascript:mw.cart.remove('<?php print $item['id'] ?>');" style="padding: 8px 10px; font-size: 12px;"><i class="mw-icon-close" style="font-size: 10px; line-height: 18px;"></i> Remove</a>
        <?php endforeach; ?>
    <?php else: ?>
        <a class="text-center" href="#">
            <h6><?php _e('0 ITEMS ON YOUR CART'); ?></h6>
        </a>
    <?php endif; ?>
</div>

<!-- quick cart footer -->
<div class="quick-cart-footer clearfix">
    <?php
    if (!isset($params['checkout-link-enabled'])) {
        $checkout_link_enanbled = get_option('data-checkout-link-enabled', $params['id']);
    } else {
        $checkout_link_enanbled = $params['checkout-link-enabled'];
    }
    ?>

    <?php if ($checkout_link_enanbled != 'n') : ?>
        <?php
        $checkout_page = get_option('data-checkout-page', $params['id']);
        if ($checkout_page != false and strtolower($checkout_page) != 'default' and intval($checkout_page) > 0) {
            $checkout_page_link = content_link($checkout_page) . '/view:checkout';
        } else {
            $checkout_page_link = checkout_url();
        }
        ?>
        <a href="<?php print $checkout_page_link; ?>" class="btn btn-primary btn-xs pull-right"><?php _e('VIEW CART'); ?></a>
    <?php endif; ?>

    <span class="pull-left"><strong>TOTAL:</strong> <?php print currency_format($total_price); ?></span>
</div>



