<?php

/*

type: layout

name: Related Projects

description: skin-3

*/
?>

<?php
$columns = get_option('columns', $params['id']);
if ($columns === null OR $columns === false OR $columns == '') {
    $columns = 'col-12 col-lg-4';
}

$columns_xl = get_option('columns-xl', $params['id']);
$thumb_quality = '1920';
if ($columns_xl != null OR $columns_xl != false OR $columns_xl != '') {
    if ($columns_xl == 'col-xl-12') {
        $thumbs_columns = 1;
    } else if ($columns_xl == 'col-xl-6') {
        $thumbs_columns = 2;
    } else if ($columns_xl == 'col-xl-4') {
        $thumbs_columns = 3;
    } else if ($columns_xl == 'col-xl-3') {
        $thumbs_columns = 4;
    } else if ($columns_xl == 'col-xl-2') {
        $thumbs_columns = 6;
    }

    $thumb_quality = 1920 / $thumbs_columns;
}
?>


<div class="row portfolio-projects">
    <?php if (!empty($data)): ?>
        <?php foreach ($data as $item): ?>
            <div class="<?php print $columns; ?>" itemscope itemtype="<?php print $schema_org_item_type_tag ?>">
                <div class="project">
                    <?php if (!isset($show_fields) or $show_fields == false or in_array('thumbnail', $show_fields)): ?>
                        <a href="<?php print $item['link'] ?>" itemprop="url">
                            <div class="image" style="background-image: url('<?php print thumbnail($item['image'], 450, 450, true); ?>');">
                                <div class="hover">
                                    <a href="#" class="btn btn-default"><i class="material-icons">remove_red_eye</i></a>
                                </div>
                            </div>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<?php if (isset($pages_count) and $pages_count > 1 and isset($paging_param)): ?>
    <?php print paging("num={$pages_count}&paging_param={$paging_param}&current_page={$current_page}") ?>
<?php endif; ?>
