<div id="settings-holder">
    <div class="col-xs-12">
        <h5 style="font-weight: bold;"><?php _lang("Website Settings", "templates/sofbox"); ?></h5>
    </div>

    <script>mw.lib.require('bootstrap3ns');</script>
    <link rel="stylesheet" href="<?php print template_url(); ?>assets/css/style-customizer.css"/>
    <style>

        #color-scheme {
            display: none;
        }

        .theme-color-selector button {
            border: 1px solid transparent;
            width: 30px;
            height: 30px;
            background: #425cbb;
            margin: 3px;
            outline: none !important;
        }

        .theme-color-selector button.active {
            border: 1px solid #0a0a0a;
        }

        .theme-color-selector button[data-color="blue"] {
            background: #428fbb;
        }

        .theme-color-selector button[data-color="brightgreen"] {
            background: #42bb59;
        }

        .theme-color-selector button[data-color="darkorange"] {
            background: #bb8c42;
        }

        .theme-color-selector button[data-color="darkred"] {
            background: #bb5042;
        }

        .theme-color-selector button[data-color="deepred"] {
            background: #bb4242;
        }

        .theme-color-selector button[data-color="green"] {
            background: #54c39d;
        }

        .theme-color-selector button[data-color="mediumblue"] {
            background: #54bcc3;
        }

        .theme-color-selector button[data-color="olivegreen"] {
            background: #92bb42;
        }

        .theme-color-selector button[data-color="pink"] {
            background: #bb426d;
        }

        .theme-color-selector button[data-color="purple"] {
            background: #bc54c3;
        }

        .theme-color-selector button[data-color="orounda-blue"] {
            background: #0086ed;
        }
    </style>

    <script>
        $(document).ready(function () {
            $('#color-scheme').on('change', function () {
                var color = $(this).val();

                if (color == '') {
                    color = '<?php print template_url(); ?>assets/css/theme.css';
                } else {
                    color = '<?php print template_url(); ?>assets/css/color-' + color + '.css';
                }

                top.$('#theme-color').attr('href', color);
            });

            $('.theme-color-selector button').on('click', function () {
                var choosedColor = $(this).data('color');
                console.log($('#color-scheme option[data-color="' + choosedColor + ']"'));

                $('#color-scheme option').prop('selected', false);
                $('#color-scheme option[value="' + choosedColor + '"]').prop('selected', true);
                $('#color-scheme').change();

                $('.theme-color-selector button').removeClass('active');
                $(this).addClass('active');
            });
        });
    </script>

    <div class="bootstrap3ns">
        <?php

        $preloader = get_option('preloader', 'mw-template-sofbox');
        if ($preloader == '') {
            $preloader = 'false';
        } else {
            $preloader = 'true';
        }

        $header_style = get_option('header-style', 'mw-template-sofbox');
        if ($header_style == '') {
            $header_style = 'style-1';
        }

        $shopping_cart = get_option('shopping-cart', 'mw-template-sofbox');
        if ($shopping_cart == '') {
            $shopping_cart = 'false';
        } else {
            $shopping_cart = 'true';
        }

        $profile_link = get_option('profile-link', 'mw-template-sofbox');
        if ($profile_link == '') {
            $profile_link = 'false';
        } else {
            $profile_link = 'true';
        }

        $footer = get_option('footer', 'mw-template-sofbox');
        if ($footer == '') {
            $footer = 'false';
        }

        $color_scheme = get_option('color-scheme', 'mw-template-sofbox');
        if ($color_scheme == '') {
            $color_scheme = '';
        }
        ?>

        <div class="form-group">
            <div class="col-xs-12">
                <div class="checkbox">
                    <label>
                        <input type="checkbox" class="mw_option_field" id="preloader" name="preloader" data-option-group="mw-template-sofbox" value="true" <?php if ($preloader == 'true') {
                            echo 'checked';
                        } ?> /> <?php _lang("Turn on Page Preloader", "templates/sofbox"); ?>
                    </label>
                </div>
            </div>
        </div>

        <div class="form-group">
            <label for="select" class="col-lg-2 control-label">Header Style</label>
            <div class="col-lg-10">
                <select name="header-style" id="header-style" class="mw_option_field form-control" data-option-group="mw-template-sofbox">
                    <option value="style-1" <?php if ($header_style == 'style-1') {
                        echo 'selected';
                    } ?>>Style 1
                    </option>
                    <option value="style-2"<?php if ($header_style == '' OR $header_style == 'style-2') {
                        echo 'selected';
                    } ?>>Style 2
                    </option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-12">
                <div class="checkbox">
                    <label>
                        <input type="checkbox" class="mw_option_field" id="shopping-cart" name="shopping-cart" data-option-group="mw-template-sofbox" value="true" <?php if ($shopping_cart == 'true') {
                            echo 'checked';
                        } ?> /> <?php _lang("Show shopping cart in header", "templates/sofbox"); ?>
                    </label>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-12">
                <div class="checkbox">
                    <label>
                        <input type="checkbox" class="mw_option_field" id="profile-link" name="profile-link" data-option-group="mw-template-sofbox" value="true" <?php if ($profile_link == 'true') {
                            echo 'checked';
                        } ?> /> Show Profile link in header
                    </label>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-xs-12">
                <div class="checkbox">
                    <label>
                        <input type="checkbox" class="mw_option_field" id="footer" name="footer" data-option-group="mw-template-sofbox" value="true" <?php if ($footer == 'true') {
                            echo 'checked';
                        } ?> /> <?php _lang("Turn off Footer for website", "templates/sofbox"); ?>
                    </label>
                </div>
            </div>
        </div>

        <!--<div class="form-group">
            <label for="select" class="col-lg-2 control-label">Color scheme</label>
            <div class="col-lg-10">
                <div class=" iq-customizer">
                    <ul class="iq-colorChange clearfix">
                        <li class="color-1 selected" data-style="color-1"></li>
                        <li class="color-2" data-style="color-2"></li>
                        <li class="color-3" data-style="color-3"></li>
                        <li class="color-4" data-style="color-4"></li>
                        <li class="color-5" data-style="color-5"></li>
                        <li class="color-6" data-style="color-6"></li>
                        <li class="color-7" data-style="color-7"></li>
                        <li class="color-8" data-style="color-8"></li>
                    </ul>
                </div>

                <div class="theme-color-selector">
                    <button data-color="" <?php /*if ($color_scheme == '') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="blue" <?php /*if ($color_scheme == 'color-1') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="brightgreen" <?php /*if ($color_scheme == 'brightgreen') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="darkorange" <?php /*if ($color_scheme == 'darkorange') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="darkred" <?php /*if ($color_scheme == 'darkred') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="deepred" <?php /*if ($color_scheme == 'deepred') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="green" <?php /*if ($color_scheme == 'green') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="mediumblue" <?php /*if ($color_scheme == 'mediumblue') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="olivegreen" <?php /*if ($color_scheme == 'olivegreen') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="pink" <?php /*if ($color_scheme == 'pink') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="purple" <?php /*if ($color_scheme == 'purple') {
                        echo 'class="active"';
                    } */?>></button>
                    <button data-color="orounda-blue" <?php /*if ($color_scheme == 'orounda-blue') {
                        echo 'class="active"';
                    } */?>></button>
                </div>

                <select name="color-scheme" id="color-scheme" class="mw_option_field form-control" data-option-group="mw-template-dream">
                    <option value="" <?php /*if ($color_scheme == '') {
                        echo 'selected';
                    } */?>>Default
                    </option>

                    <option value="blue"<?php /*if ($color_scheme == 'blue') {
                        echo 'selected';
                    } */?>>Blue
                    </option>
                    <option value="brightgreen"<?php /*if ($color_scheme == 'brightgreen') {
                        echo 'selected';
                    } */?>>Bright Green
                    </option>
                    <option value="darkorange"<?php /*if ($color_scheme == 'darkorange') {
                        echo 'selected';
                    } */?>>Dark Orange
                    </option>
                    <option value="darkred"<?php /*if ($color_scheme == 'darkred') {
                        echo 'selected';
                    } */?>>Dark Red
                    </option>
                    <option value="deepred"<?php /*if ($color_scheme == 'deepred') {
                        echo 'selected';
                    } */?>>Deep Red
                    </option>
                    <option value="green"<?php /*if ($color_scheme == 'green') {
                        echo 'selected';
                    } */?>>Green
                    </option>
                    <option value="mediumblue"<?php /*if ($color_scheme == 'mediumblue') {
                        echo 'selected';
                    } */?>>Medium Blue
                    </option>
                    <option value="olivegreen"<?php /*if ($color_scheme == 'olivegreen') {
                        echo 'selected';
                    } */?>>Olive Green
                    </option>
                    <option value="pink"<?php /*if ($color_scheme == 'pink') {
                        echo 'selected';
                    } */?>>Pink
                    </option>
                    <option value="purple"<?php /*if ($color_scheme == 'purple') {
                        echo 'selected';
                    } */?>>Purple
                    </option>
                    <option value="orounda-blue"<?php /*if ($color_scheme == 'orounda-blue') {
                        echo 'selected';
                    } */?>>orounda-blue
                    </option>
                </select>
            </div>
        </div>-->


        <module type="template_settings/admin"/>


    </div>
</div>
<!-- /#settings-holder -->