<?php

/*

type: layout

name: Default

description: Testimonials Default

*/

?>


<div class="owl-carousel" data-nav-dots="false" data-nav-arrow="true" data-items="3" data-xs-items="1" data-sm-items="2" data-md-items="3" data-lg-items="3"
     data-autoplay="true">
    <?php $data = get_testimonials(); ?>
    <?php if (isset($data)): ?>
        <?php foreach ($data as $item) { ?>
            <div class="item">
                <div class="iq-client white-bg">
                    <?php if ($item['client_picture']): ?>
                        <div class="client-img">
                            <img alt="" class="img-responsive img-circle" src="<?php print thumbnail($item['client_picture'], 100, 100, true); ?>">
                        </div>
                    <?php endif; ?>
                    <div class="client-info">
                        <div class="client-name iq-mb-10">
                            <?php if (isset($item['client_website'])) { ?>
                                <h5 class="iq-tw-6"><a href="<?php print $item['client_website']; ?>" target="_blank"><?php print $item['name']; ?></a></h5>
                            <?php } else { ?>
                                <h5 class="iq-tw-6"><?php print $item['name']; ?></h5>
                            <?php } ?>

                            <?php if (isset($item["client_company"])) { ?>
                                <span class="sub-title iq-tw-6">
                                    <?php print $item['client_company']; ?>
                                    <?php if (isset($item["client_role"])) { ?>
                                        - <?php print $item['client_role']; ?>
                                    <?php } ?>
                                </span>
                            <?php } ?>
                        </div>
                        <p><?php print $item['content']; ?></p>
                    </div>
                </div>
            </div>
        <?php } ?>
    <?php endif; ?>
</div>