$(document).ready(function () {
    $(window).bind('mw.cart.add', function (event, data) {

        if (document.getElementById('AddToCartModal') === null) {

            AddToCartModal = mw.modal({

                content: AddToCartModalContent(data.product.title),

                template: 'mw_modal_basic',

                name: "AddToCartModal",

                width: 400,

                height: 200

            });

        }

        else {

            AddToCartModal.container.innerHTML = AddToCartModalContent(data.product.title);

        }
    });

    $('.mw-ui-btn').on('click', function () {
        var cart_icon = $('body .mw-cart-active').length;

        if (cart_icon > 0) {
            var cart = $('.mw-cart-active');
            var imgtodrag = $(this).parents('.tplactive-item').find('.product-active-image').eq(0);

            if (imgtodrag) {
                var imgclone = imgtodrag.clone();
                imgclone = $(imgclone[0])

                imgclone.css({
                    top: imgtodrag.offset().top,
                    left: imgtodrag.offset().left,
                    'opacity': '0.8',
                    'position': 'absolute',
                    'height': '150px',
                    'width': '150px',
                    'z-index': '100',
                    'border-radius': '10px'
                })
                    .appendTo($('body'))
                    .animate({
                        'top': cart.offset().top + 10,
                        'left': cart.offset().left + 10,
                        'width': 75,
                        'height': 75
                    }, 1000, 'easeInOutExpo');

                setTimeout(function () {
                    cart.effect("shake", {
                        times: 2
                    }, 200);
                }, 1500);

                imgclone.animate({
                    'width': 0,
                    'height': 0
                }, function () {
                    $(this).detach()
                });
            }
        }
    });
});