<?php

include_once(__DIR__ . '/../functions.php');
include_once(__DIR__ . '/../config.php');

use Composer\Semver\Comparator;


class RoboFile extends \Robo\Tasks
{
    //use  \Robo\Task\Base\loadTasks;
    public $workdir = __DIR__ . '/../../workdir/core';
    public $urls = array();
    public $report_data = array();
    public $shared_git_ready_folder = __DIR__ . '/../../workdir/core/git_ready';
    public $shared_git_folder = __DIR__ . '/../../workdir/core/git';
    public $git_tags_folder = __DIR__ . '/../../workdir/core/git_tags';

    public $shared_git_make_folder = __DIR__ . '/../../workdir/core/git_make';

    public $shared_zip_folder = __DIR__ . '/../../workdir/core/zip';
    public $shared_tests_folder = __DIR__ . '/../../workdir/core/tests';
    public $shared_build_folder = __DIR__ . '/../../workdir/core/build';
    public $shared_patch_folder = __DIR__ . '/../../workdir/core/patch';
    public $shared_update_folder = __DIR__ . '/../../workdir/core/update';
    public $report_file = __DIR__ . '/../../workdir/core/report.json';
    public $public_html_folder = __DIR__ . '/../../public_html/ready';
    public $public_html_folder_test_folder = __DIR__ . '/../../public_html/test';
    public $public_html_folder_zip_folder = __DIR__ . '/../../public_html/ready/core';
    public $public_reports_folder = __DIR__ . '/../../public_html/ready/reports';
    public $phpunit_phar = __DIR__ . '/../phpunit-6.2.phar';

    public function __construct()
    {
//        $this->workdir = dirname(__DIR__) . '/workdir';
//        $this->shared_git_folder = $this->workdir . '/git';
//        $this->shared_git_ready_folder = $this->workdir . '/git_ready';
//        $this->shared_zip_folder = $this->workdir . '/zip';
//        $this->shared_tests_folder = $this->workdir . '/tests';
//        $this->shared_build_folder = $this->workdir . '/build';
//        $this->shared_patch_folder = $this->workdir . '/patch';
//        $this->shared_update_folder = $this->workdir . '/update';
//        $this->public_html_folder = dirname(__DIR__) . '/public_html';
//        $this->public_reports_folder = dirname(__DIR__) . '/public_html/reports';

        $this->urls = get_repos_urls('core');
        // $this->workdir = $robo_workdir;
    }


    function run()
    {

        if (!is_dir($this->workdir)) {
            mkdir($this->workdir, 755);
            //mkdir_recursive($this->workdir, true);
        }


        //  $urls['templates/gene'] = 'git@bitbucket.org:mw-internal/template_gene.git';

        //

        $sync_folders = $this->urls;
        $sync_folders = $this->step_1_get_from_git($sync_folders);
        if ($sync_folders) {
            $sync_folders = $this->step_1_rsync_local($sync_folders);

            $sync_folders = $this->step_1_build_vendor($sync_folders);
            $sync_folders = $this->step_1_make_tests($sync_folders);

            // step 2
            //  dd($sync_folders);
            $sync_folders = $this->patch();
            $this->check_for_anomalies($sync_folders);


            $sync_folders = $this->step_3_create_zips($this->urls);

            $this->check_for_anomalies();

            $this->write_report_file();


        }

        $this->step_3_publish_zips_on_public_html();


    }

    function patch($sync_folders = false)
    {
        if (!$sync_folders) {
            $sync_folders = $this->urls;
        }
        $sync_folders = $this->step_2_build_patch($sync_folders);
        // $sync_folders = $this->step_2_make_patch_tests($sync_folders);
        $this->write_report_file();

        return $sync_folders;
    }


    function step_1_get_from_git($urls)
    {

        $repo_commit_hash_file = $this->workdir . DIRECTORY_SEPARATOR . 'git_cache.json';
        if (!is_file($repo_commit_hash_file)) {
            touch($repo_commit_hash_file);
        }
        $repo_commit_hash = $repo_commit_hash_orig = @json_decode(@file_get_contents($repo_commit_hash_file), 1);

        $return_urls = array();
        foreach ($urls as $repo_conf) {

            $folder = $folder_repo = $repo_conf['folder'];
            $url = $repo_conf['repo'];
            $branch = $repo_conf['branch'];
            $folder = $this->shared_git_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;
            if (!is_dir($folder)) {
                mkdir_recursive($folder);
            }

            if (!is_dir($folder . '.git')) {
                mkdir_recursive($folder);
                $cmd2 = "mkdir -p {$folder} &&  cd $folder &&  git init && git remote add origin $url && git pull";
                $cmd2 = "mkdir -p {$folder} &&  cd $folder &&  git init && git remote add origin $url && git branch --set-upstream-to=origin/$branch $branch && git pull";

                //


                var_dump($cmd2);
                $this->_exec($cmd2);
            }

            $prev_hash = false;
            $is_error = false;
            if (isset($repo_commit_hash[$folder_repo][$branch]['hash'])) {
                $prev_hash = $repo_commit_hash[$folder_repo][$branch]['hash'];
            }

            if (isset($repo_commit_hash[$folder_repo][$branch]['error'])) {
                $is_error = $repo_commit_hash[$folder_repo][$branch]['error'];
            }


            $cmsds = array();
            $cmsds[] = "cd $folder";
            //  $cmsds[] = "git branch -u origin/$branch";
            $cmsds[] = "git fetch --all";
            //  $cmsds[] = "git fetch --all";
            $cmsds[] = "git reset --hard origin/$branch";
            $cmsds[] = "git pull origin $branch";


            d($folder);

            $cmd2 = implode(' && ', $cmsds);
            $shell = shell_exec($cmd2);


            $cmsds = array();
            $cmsds[] = "cd $folder";
            $cmsds[] = "git rev-parse HEAD | cut -c1-10";
            //     $cmsds[] = "git ls-remote $url | grep HEAD | awk '{ print $1}'";
            $cmd2 = implode(' && ', $cmsds);
            $shell = shell_exec($cmd2);


            $cur_hash = trim($shell);
            d('hash: ' . $cur_hash);
            $skip = false;
            if ($prev_hash and $cur_hash and $prev_hash == $cur_hash) {
                $skip = true;
            }
            if ($is_error) {
                $skip = false;
            }
            $repo_commit_hash[$folder_repo][$branch]['hash'] = $cur_hash;


            if (!$skip) {
                $repo_conf['hash'] = $cur_hash;

                $return_urls[] = $repo_conf;


                $cmsds = array();
                $cmsds[] = "cd $folder";
                $cmsds[] = "git remote set-url origin $url";
                $cmsds[] = "git fetch --all";
                //  $cmsds[] = "git reset --hard origin/{$branch}";
                //     ..  $cmsds[] = "git reset --soft HEAD@{1}";
                //  $cmsds[] = "git reset --hard ";
                $cmsds[] = "git clean -dfx";
                //  $cmsds[] = "git pull";

                //git fetch origin
                // git reset --hard origin/master (or your branch name)

                //   $cmsds[] = 'git reset --hard FETCH_HEAD';
                //  $cmsds[] = 'git reset --hard HEAD ';
                $cmsds[] = "git pull origin $branch";
                $cmd2 = implode(' && ', $cmsds);
                d($cmd2);
                $this->_exec($cmd2);

            }
        }


        if ($repo_commit_hash_orig != $repo_commit_hash) {
            file_put_contents($repo_commit_hash_file, json_encode($repo_commit_hash, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));
        }

        return $return_urls;

    }


    function step_1_rsync_local($urls)
    {

        $return_urls = array();
        foreach ($urls as $repo_conf) {

            $folder = $repo_conf['folder'];
            $url = $repo_conf['repo'];
            $branch = $repo_conf['branch'];
            $to_folder = $this->shared_git_ready_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;
            $from_folder = $this->shared_git_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;


            $this->_ccopydir($from_folder, $to_folder);


            if (is_dir($to_folder . '.git')) {
                $this->say('Removing .git folder');

                rrmdir($to_folder . '.git');
            }

            $return_urls[] = $repo_conf;
        }

        return $return_urls;
    }


    public function step_1_build_vendor($urls)
    {
        $return_urls = array();

        foreach ($urls as $repo_conf) {

            $folder = $repo_conf['folder'];
            $url = $repo_conf['repo'];
            $branch = $repo_conf['branch'];
            $step_1_build_vendor = false;
            if (isset($repo_conf['build_vendor']) and $repo_conf['build_vendor']) {
                $step_1_build_vendor = 1;
            }
            $to_folder = $this->shared_build_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;

            $from_folder = $this->shared_git_ready_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;


            $this->_ccopydir($from_folder, $to_folder);


            if (is_file($to_folder . 'composer.json')) {

                if ($step_1_build_vendor) {
                    $this->taskComposerValidate()->dir($to_folder)->run();

                    $this->taskComposerInstall()
                        ->noInteraction()
                        //   ->ignorePlatformRequirements(true)
                        ->dir($to_folder)
                        ->preferDist()
                        ->run();
                    $repo_conf['task_vendor_built'] = true;
                }
            }


            $return_urls[] = $repo_conf;

        }
        return $return_urls;
    }


    public function step_1_make_tests($urls)
    {
        $return_urls = array();
        foreach ($urls as $repo_conf) {

            $folder = $repo_conf['folder'];
            $url = $repo_conf['repo'];
            $branch = $repo_conf['branch'];
            $skip_unit_test = false;
            if (isset($repo_conf['skip_unit_test']) and $repo_conf['skip_unit_test']) {
                $skip_unit_test = $repo_conf['skip_unit_test'];
            }

            $from_folder = $this->shared_build_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;
            $to_folder = $this->shared_tests_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;
            $this->_ccopydir($from_folder, $to_folder);

//            $this->taskPhpspec()
//                ->format('pretty')
//                ->dir($from_folder)
//                ->noInteraction()
//                ->run();


            if (is_file($to_folder . 'phpunit.xml') and !$skip_unit_test) {
                $this->taskPHPUnit($this->phpunit_phar)
                    ->dir($to_folder)
                    // ->arg('-v')
                    ->run();
                $repo_conf['task_phpunit'] = true;

            }

            $return_urls[] = $repo_conf;

        }
        return $return_urls;

    }

    public function step_2_build_patch($urls)
    {
        $return_urls = array();

        $all_urls = get_repos_urls();

        foreach ($urls as $repo_conf) {

            $folder = $repo_conf['folder'];
            $url = $repo_conf['repo'];
            $branch = $repo_conf['branch'];
            $next_version = false;
            $update_files = false;
            $next_version_repo_conf = false;


            if (isset($repo_conf['next_version']) and $repo_conf['next_version']) {
                $next_version = $repo_conf['next_version'];
            }
            if (isset($repo_conf['update_files']) and $repo_conf['update_files']) {
                $update_files = $repo_conf['update_files'];
            }

            if ($next_version) {
                // find config of next version
                $repo_conf['next_version'] = $next_version;
                foreach ($all_urls as $next_repo_conf) {
                    if ($repo_conf != $next_repo_conf and isset($next_repo_conf['version']) and $next_repo_conf['version'] and $next_repo_conf['version'] == $next_version) {
                        $next_version_repo_conf = $next_repo_conf;
                        $this->say('Next version found for patch: ' . $next_version);

                    }
                }
            }
            // dd($repo_conf,$all_urls);
            if ($next_version_repo_conf) {


                $folder_next = $next_version_repo_conf['folder'];
                $branch_next = $next_version_repo_conf['branch'];
                $update_files_next = false;
                if (isset($repo_conf['update_files']) and $repo_conf['update_files']) {
                    $update_files_next = $repo_conf['update_files'];
                }
                $new_ver_folder = $this->shared_build_folder . DIRECTORY_SEPARATOR . $folder_next . DIRECTORY_SEPARATOR . $branch_next . DIRECTORY_SEPARATOR;
                $new_ver_folder_update = $this->shared_update_folder . DIRECTORY_SEPARATOR . $folder_next . DIRECTORY_SEPARATOR . $branch . '-' . $branch_next . '-update' . DIRECTORY_SEPARATOR;
                $old_ver_folder = $this->shared_build_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;
                $new_ver_folder_patch = $this->shared_patch_folder . DIRECTORY_SEPARATOR . $folder_next . DIRECTORY_SEPARATOR . $branch . '-' . $branch_next . '-patch' . DIRECTORY_SEPARATOR;
                $public_html_folder_test_folder = $this->public_html_folder_test_folder . DIRECTORY_SEPARATOR . $folder_next . DIRECTORY_SEPARATOR . $branch . '-' . $branch_next . DIRECTORY_SEPARATOR;


                if (!is_dir($new_ver_folder_update)) {
                    mkdir_recursive($new_ver_folder_update);
                }
                if (!is_dir($new_ver_folder_patch)) {
                    mkdir_recursive($new_ver_folder_patch);
                }
                if (!is_dir($public_html_folder_test_folder)) {
                    mkdir_recursive($public_html_folder_test_folder);
                }

                $this->_cleanDir($new_ver_folder_update);
                $this->_cleanDir($new_ver_folder_patch);


                $this->_ccopydir($new_ver_folder, $new_ver_folder_update);


                $this->_ccopydir($new_ver_folder, $public_html_folder_test_folder);


                $diff1 = checksum_dir_files($new_ver_folder);
                $diff2 = checksum_dir_files($old_ver_folder);

                $targetdir = $new_ver_folder;
                $diff1 = array_map(
                    function ($str) use ($targetdir) {
                        $str = str_replace($targetdir, '', $str);
                        return str_replace('\\', '/', $str);
                    },
                    $diff1
                );


                $targetdir = $old_ver_folder;
                $diff2 = array_map(
                    function ($str) use ($targetdir) {
                        $str = str_replace($targetdir, '', $str);
                        return str_replace('\\', '/', $str);
                    },
                    $diff2
                );


                $diff_patch = @array_diff_assoc($diff1, $diff2);


                if (count($diff_patch) < 5) {
                    //@todo check for vendor 3 files
                    // if only autoload files are here we must skip them
                    foreach ($diff_patch as $diff_patch_file) {
                        if (strstr($diff_patch_file, 'vendor')) {
                            dd($diff_patch, '@fixme: zazaza if only autoload files are here we must skip them', __FILE__, __LINE__);
                        }
                    }

                    // dd($diff_patch);

                }

                if ($diff_patch) {
                    $items = array();
                    $items_in_vendor = array();
                    foreach ($diff_patch as $k => $item) {
                        if (strstr($item, 'vendor/')) {
                            $items_in_vendor[$k] = $item;
                        } else {
                            $items[$k] = $item;

                        }
                    }
                    if (count($items_in_vendor) > 4) {
                        $diff_patch = array_merge($items, $items_in_vendor);

                    } else {
                        $diff_patch = $items;

                    }
                }


                if ($diff_patch) {
                    $repo_conf['next_version_diff'] = $diff_patch;

                    foreach ($diff_patch as $fn) {
                        $dn = $new_ver_folder_patch . dirname($fn) . DIRECTORY_SEPARATOR;
                        if (!is_dir($dn)) {
                            mkdir_recursive($dn);
                        }
                        $cp1 = $new_ver_folder . $fn;
                        $cp2 = $new_ver_folder_patch . $fn;
                        if (!is_dir(dirname($cp2))) {
                            mkdir_recursive(dirname($cp2));
                        }
                        $this->say('Copy from: ' . $cp1 . ' to ' . $cp2);
                        copy($cp1, $cp2);
                    }
                }
                //      dd($new_ver_folder, $old_ver_folder, $new_ver_folder_update,$diff_patch);


                if ($update_files_next) {
                    if (isset($update_files_next['remove'])) {
                        foreach ($update_files_next['remove'] as $rmf) {
                            $rm1 = $new_ver_folder_update . $rmf;
                            $rm2 = $new_ver_folder_patch . $rmf;
                            if (is_dir($rm1)) {
                                $this->say('Removing: ' . $rm1);

                                rrmdir($rm1);
                            }
                            if (is_dir($rm2)) {
                                $this->say('Removing: ' . $rm2);

                                rrmdir($rm2);
                            }


                        }
                    }

                    if (isset($update_files_next['update'])) {
                        foreach ($update_files_next['update'] as $cpf) {


                            $cpf_o = $new_ver_folder . $cpf;
                            $this->say('Copy from: ' . $cpf_o);

                            if (is_file($cpf_o) or is_dir($cpf_o)) {
//                                $cp1 = $cpf_o;
//                                $cp2 = $new_ver_folder_patch . $cpf;
//                                if (!is_dir($cp2)) {
//                                    mkdir_recursive(dirname($cp2));
//                                }
//                                if (is_dir($cpf_o) and !is_dir($cp2)) {
//                                    mkdir_recursive($cp2);
//                                }
//
//
//                                $this->say('Copy to: ' . $cp2);
//
//                                if (is_dir($cp1)) {
//                                    $this->_ccopydir($cp1, $cp2);
//                                } else {
//                                    copy($cp1, $cp2);
//                                }
//
//

                                $cp1 = $cpf_o;
                                $cp2 = $new_ver_folder_update . $cpf;
                                if (!is_dir(dirname($cp2))) {
                                    mkdir_recursive(dirname($cp2));
                                }
                                $this->say('Copy to: ' . $cp2);

                                if (is_dir($cp1)) {
                                    $this->_ccopydir($cp1, $cp2);
                                } else {
                                    copy($cp1, $cp2);
                                }

                            }


                        }
                    }


                }

            }


            $return_urls[] = $repo_conf;

        }
        return $return_urls;

    }


    public function step_2_make_patch_tests($urls)
    {
        $return_urls = array();

        $all_urls = get_repos_urls();

        $installs = array();
        foreach ($urls as $repo_conf) {

            $folder = $repo_conf['folder'];
            $url = $repo_conf['repo'];
            $branch = $repo_conf['branch'];

            $type = $repo_conf['type'];
            if ($type == 'core') {


                $next_version = false;
                $update_files = false;
                $next_version_repo_conf = false;
                $is_last_version = false;


                if (isset($repo_conf['next_version']) and $repo_conf['next_version']) {
                    $next_version = $repo_conf['next_version'];
                }
                if (isset($repo_conf['update_files']) and $repo_conf['update_files']) {
                    $update_files = $repo_conf['update_files'];
                }
                if (isset($repo_conf['is_last_version']) and $repo_conf['is_last_version']) {
                    $is_last_version = $repo_conf['is_last_version'];
                }

                if ($is_last_version) {
                    $out_folder = 'tests' . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . 'last_version' . DIRECTORY_SEPARATOR;
                    $from_folder = $this->shared_build_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;
                    //   $to_folder = $this->public_html_folder . DIRECTORY_SEPARATOR . $out_folder;
                    $to_folder = $this->public_html_folder_test_folder . DIRECTORY_SEPARATOR . $out_folder;
                    $this->report_data[$folder]['is_last_version'] = array(
                        'branch' => $branch,
                        'folder' => $folder,
                        'link' => $out_folder,
                        'config' => $repo_conf,
                    );


                    $this->_ccopydir($from_folder, $to_folder);
                    $this->_mw_make_install($to_folder);

                }

                if ($next_version) {
                    // find config of next version
                    foreach ($all_urls as $next_repo_conf) {
                        if ($repo_conf != $next_repo_conf and isset($next_repo_conf['version']) and $next_repo_conf['version'] and $next_repo_conf['version'] == $next_version) {
                            $next_version_repo_conf = $next_repo_conf;
                        }
                    }


                    if ($next_version_repo_conf and !empty($next_version_repo_conf)) {
                        $folder_next = $next_version_repo_conf['folder'];
                        $branch_next = $next_version_repo_conf['branch'];


                        $out_folder = '' . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;
                        $out_folder2 = '' . DIRECTORY_SEPARATOR . $folder_next . DIRECTORY_SEPARATOR . $branch . '-' . $branch_next . '-update' . DIRECTORY_SEPARATOR;

                        $from_folder = $this->shared_build_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;
                        $to_folder = $this->public_html_folder_test_folder . DIRECTORY_SEPARATOR . $out_folder;
                        $to_folder2 = $this->public_html_folder_test_folder . DIRECTORY_SEPARATOR . $out_folder2;


                        $this->_ccopydir($from_folder, $to_folder);
                        $this->_ccopydir($from_folder, $to_folder2);


                        $this->report_data[$folder][$branch] = array(
                            'branch' => $branch,
                            'folder' => $folder,
                            'link' => $out_folder,
                            'config' => $repo_conf,
                        );
                        $this->report_data[$folder][$branch] = array(
                            'branch' => $branch,
                            'folder' => $folder,
                            'link' => $out_folder2,
                            'compare_link' => $out_folder,
                            'config' => $next_version_repo_conf,
                        );


                        $installs[] = $to_folder;
                        $installs[] = $to_folder2;

                        $this->_mw_make_install($to_folder);
                        $this->_mw_make_install($to_folder2);

                        $new_ver_folder_patch = $this->shared_patch_folder . DIRECTORY_SEPARATOR . $folder_next . DIRECTORY_SEPARATOR . $branch . '-' . $branch_next . '-patch' . DIRECTORY_SEPARATOR;
                        $this->say('Copying patch files from ' . $new_ver_folder_patch);

                        $this->taskCopyDir([$new_ver_folder_patch => $to_folder2])->overwrite(true)->run();

                        $this->taskPHPUnit($this->phpunit_phar)
                            ->dir($to_folder2)
                            ->run();
                        $repo_conf['task_phpunit_patch'] = true;


                    }

                }


            }

            $return_urls[] = $repo_conf;

        }


        foreach ($installs as $install) {
            $this->check_folder_for_syntax_errors($install);

        }

        return $return_urls;

    }


    public function step_3_create_zips($urls = false)
    {
        $all_urls = get_repos_urls();
        if (!$urls) {
            $urls = $all_urls;
        }

        $return_urls = array();

        foreach ($urls as $repo_conf) {
            $next_version = false;
            $folder_next = false;
            $folder = $repo_conf['folder'];
            $url = $repo_conf['repo'];
            $branch = $repo_conf['branch'];
            $ver = $repo_conf['version'];


            if (isset($repo_conf['next_version']) and $repo_conf['next_version']) {
                $next_version = $repo_conf['next_version'];
            }
            $next_version_repo_conf = false;

            $repo_conf['next_version'] = $next_version;
            if ($next_version) {
                foreach ($all_urls as $next_repo_conf) {
                    if ($repo_conf != $next_repo_conf and isset($next_repo_conf['version']) and $next_repo_conf['version'] and $next_repo_conf['version'] == $next_version) {
                        $next_version_repo_conf = $next_repo_conf;
                        $this->say('Next version found for patch: ' . $next_version);

                    }
                }
            }


            if ($next_version_repo_conf) {
                $folder_next = $next_version_repo_conf['folder'];
                $branch_next = $next_version_repo_conf['branch'];
            }

            $to_folder = $this->shared_zip_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;

            $from_folder = $this->shared_update_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch;
            $from_folder2 = $this->shared_patch_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch;
            $from_folder3 = $this->shared_build_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch;


            $from_folder = $this->shared_update_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . '-' . $next_version . '-update' . DIRECTORY_SEPARATOR;;
            $from_folder2 = $this->shared_patch_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . '-' . $next_version . '-patch' . DIRECTORY_SEPARATOR;;
            $from_folder3 = $this->shared_build_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;


            $public_html_folder_test_folder = $this->public_html_folder_test_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;;


            if (!is_dir($to_folder)) {
                mkdir_recursive($to_folder);
            }
            if (!is_dir($from_folder)) {
                mkdir_recursive($from_folder);
            }
            if (!is_dir($public_html_folder_test_folder)) {
                mkdir_recursive($public_html_folder_test_folder);
            }
            $this->say('Copy from ' . $from_folder3 . ' to ' . $public_html_folder_test_folder);

            $this->_ccopydir($from_folder3, $public_html_folder_test_folder);

            $zip_name_update_full = false;
            $zip_name_update_patch = false;
            $zip_name = false;
            if (isset($repo_conf['zip_name_update_full']) and $repo_conf['zip_name_update_full']) {
                $zip_name_update_full = $repo_conf['zip_name_update_full'];
            }
            if (isset($repo_conf['zip_name_update_patch']) and $repo_conf['zip_name_update_patch']) {
                $zip_name_update_patch = $repo_conf['zip_name_update_patch'];
            }
            if (isset($repo_conf['zip_name']) and $repo_conf['zip_name']) {
                $zip_name = $repo_conf['zip_name'];
            }

            $report = $repo_conf;
            $report['build_date'] = date('Y-m-d H:i:s');
            if ($zip_name_update_full) {
                if (is_dir($from_folder)) {

                    $r2 = array();

                    $zip_dest = $to_folder . $zip_name_update_full . '.zip';
                    $report['zip_name_update_full'] = $zip_name_update_full . '.zip';


                    $r2['file'] = $zip_name_update_full . '.zip';


                    if (is_file($zip_dest)) {
                        unlink($zip_dest);
                    }
                    zip($from_folder, $zip_dest);
                    if (is_file($zip_dest)) {
                        $ch = file_split_to_parts($zip_dest, dirname($zip_dest) . DS);
                        $somedir = dirname($zip_dest) . DS;
                        $ch = array_map(
                            function ($str) use ($somedir) {
                                $str = str_replace($somedir, '', $str);
                                return str_replace('\\', '/', $str);
                            },
                            $ch
                        );


                        $r2['size'] = filesize($zip_dest);
                        $r2['md5'] = md5_file($zip_dest);
                        $r2['chunks'] = $ch;
                        $report['zip_name_update_full_size'] = filesize($zip_dest);
                        $report['zip_name_update_full_md5'] = md5_file($zip_dest);
                        $report['zip_name_update_full_chunks'] = $ch;
                        $report['zip_update'] = $r2;





                        if (isset($repo_conf['is_last_version_update']) and $repo_conf['is_last_version_update']) {
                            if (is_file($zip_dest)) {
                                copy($zip_dest, $this->shared_zip_folder . DIRECTORY_SEPARATOR . 'microweber-update.zip');
                            }
                        }





                    }


                }
                // $this->taskPack($zip_dest)->addDir('', $from_folder)->run();

            }
            if ($zip_name_update_patch) {
                if (is_dir($from_folder2)) {

                    $r2 = array();


                    $zip_dest = $to_folder . $zip_name_update_patch . '.zip';
                    $report['zip_name_update_patch'] = $zip_name_update_patch . '.zip';

                    if (is_file($zip_dest)) {
                        unlink($zip_dest);
                    }


                    $r2['file'] = $zip_name_update_patch . '.zip';


                    zip($from_folder2, $zip_dest);

                    if (is_file($zip_dest)) {
                        $ch = file_split_to_parts($zip_dest, dirname($zip_dest));

                        $somedir = dirname($zip_dest) . DS;
                        $ch = array_map(
                            function ($str) use ($somedir) {
                                $str = str_replace($somedir, '', $str);
                                return str_replace('\\', '/', $str);
                            },
                            $ch
                        );
                        if (isset($repo_conf['is_last_version_update']) and $repo_conf['is_last_version_update']) {
                            if (is_file($zip_dest)) {
                                copy($zip_dest, $this->shared_zip_folder . DIRECTORY_SEPARATOR . 'microweber-patch.zip');
                            }
                        }

                        $report['zip_name_update_patch_size'] = filesize($zip_dest);
                        $report['zip_name_update_md5'] = md5_file($zip_dest);
                        $report['zip_name_update_patch_chunks'] = $ch;

                        $r2['size'] = filesize($zip_dest);
                        $r2['md5'] = md5_file($zip_dest);
                        $r2['chunks'] = $ch;

                        $report['zip_update_patch'] = $r2;

                    }
                }

                //  $this->taskPack($zip_dest)->addDir('', $from_folder2)->run();

            }
            if ($zip_name) {

                if (is_dir($from_folder3)) {


                    $r2 = array();


                    $report_file = $to_folder . $zip_name . '.json';

                    $zip_dest = $to_folder . $zip_name . '.zip';
                    if (is_file($zip_dest)) {
                        unlink($zip_dest);
                    }
                    //    print $from_folder3;
                    //   print $zip_dest;
                    zip($from_folder3, $zip_dest);


                    $r2['file'] = $zip_name . '.zip';


                    //$this->taskPack($zip_dest)->addDir('', $from_folder3)->run();
                    $repo_conf['zip_name'] = $zip_name;


                    $report['zip_name'] = $zip_name;
                    if (is_file($zip_dest)) {


                        if (isset($repo_conf['is_last_version']) and $repo_conf['is_last_version']) {
                            if (is_file($zip_dest)) {
                                copy($zip_dest, $this->shared_zip_folder . DIRECTORY_SEPARATOR . 'microweber-latest.zip');
                            }
                        }

                        $ch = file_split_to_parts($zip_dest, dirname($zip_dest));

                        $report['zip_name_size'] = filesize($zip_dest);
                        $report['zip_name_md5'] = md5_file($zip_dest);
                        $report['zip_name_chunks'] = $ch;


                        $r2['size'] = filesize($zip_dest);
                        $r2['md5'] = md5_file($zip_dest);
                        $r2['chunks'] = $ch;

                        $report['zip_full'] = $r2;


                    }
                }

                file_put_contents($report_file, json_encode($report, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

            }

            $return_urls[] = $repo_conf;

        }
        return $return_urls;

    }

    public function step_3_publish_zips_on_public_html($urls = false)
    {

        $from_folder = $this->shared_zip_folder . DIRECTORY_SEPARATOR;
        $to_folder = $this->public_html_folder_zip_folder . DIRECTORY_SEPARATOR;

        $from_folder = realpath($from_folder);
        //$to_folder = realpath($to_folder);
        $this->say('Rsync from ' . $from_folder . ' to ' . $to_folder);

        if (!is_dir($to_folder)) {
            mkdir_recursive($to_folder);
        }
        $this->taskCopyDir([$from_folder => $to_folder])->overwrite(true)->run();


        return $urls;

        //  dd($to_folder,$from_folder);
//        $rsync = $this->taskRsync()
//            ->fromPath($from_folder)
//            ->toPath($to_folder)
//
//            ->verbose()
//            ->excludeVcs()
//            ->progress()
//            ->wholeFile()
//            ->stats()->run();


        $return_urls = array();

        foreach ($urls as $repo_conf) {

            $folder = $repo_conf['folder'];
            $url = $repo_conf['repo'];
            $branch = $repo_conf['branch'];
            $type = false;
            if (isset($repo_conf['type']) and $repo_conf['type']) {
                $type = $repo_conf['type'];
            }

            $public_html_folder = $this->public_html_folder_zip_folder . DIRECTORY_SEPARATOR . $folder;
            $to_folder = $this->shared_zip_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch . DIRECTORY_SEPARATOR;
            $from_folder = $this->shared_update_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch;
            $from_folder2 = $this->shared_patch_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch;
            $from_folder3 = $this->shared_build_folder . DIRECTORY_SEPARATOR . $folder . DIRECTORY_SEPARATOR . $branch;

            if (!is_dir($to_folder)) {
                mkdir_recursive($to_folder);
            }
            if (!is_dir($from_folder)) {
                mkdir_recursive($from_folder);
            }
            if (!is_dir($public_html_folder)) {
                mkdir_recursive($public_html_folder);
            }

            $zip_name_update_full = false;
            $zip_name_update_patch = false;
            $zip_name = false;


            if (isset($repo_conf['zip_name_update_full']) and $repo_conf['zip_name_update_full']) {
                $zip_name_update_full = $repo_conf['zip_name_update_full'];
            }
            if (isset($repo_conf['zip_name_update_patch']) and $repo_conf['zip_name_update_patch']) {
                $zip_name_update_patch = $repo_conf['zip_name_update_patch'];
            }
            if (isset($repo_conf['zip_name']) and $repo_conf['zip_name']) {
                $zip_name = $repo_conf['zip_name'];
            }


            if ($zip_name_update_full) {
                $zip_dest = $to_folder . $zip_name_update_full . '.zip';
                if (is_file($zip_dest)) {
                    copy($zip_dest, $public_html_folder . DIRECTORY_SEPARATOR . $zip_name_update_full . '.zip');

                }
                if (isset($repo_conf['is_last_version_update']) and $repo_conf['is_last_version_update']) {
                    if (is_file($zip_dest)) {
                        copy($zip_dest, $public_html_folder . DIRECTORY_SEPARATOR . 'microweber-update.zip');
                    }
                }


                // $this->taskPack($zip_dest)->addDir('', $from_folder)->run();

            }
            if ($zip_name_update_patch) {
                $zip_dest = $to_folder . $zip_name_update_patch . '.zip';
                if (is_file($zip_dest)) {
                    copy($zip_dest, $public_html_folder . DIRECTORY_SEPARATOR . $zip_name_update_patch . '.zip');
                    if (isset($repo_conf['is_last_version_update']) and $repo_conf['is_last_version_update']) {
                        if (is_file($zip_dest)) {
                            copy($zip_dest, $public_html_folder . DIRECTORY_SEPARATOR . 'microweber-patch.zip');
                        }
                    }
                }
            }
            if ($zip_name) {
                $zip_dest = $to_folder . $zip_name . '.zip';
                if (is_file($zip_dest)) {
                    copy($zip_dest, $public_html_folder . DIRECTORY_SEPARATOR . $zip_name . '.zip');

                }
                if (isset($repo_conf['is_last_version']) and $repo_conf['is_last_version']) {
                    if (is_file($zip_dest)) {
                        copy($zip_dest, $public_html_folder . DIRECTORY_SEPARATOR . 'microweber-latest.zip');
                    }
                }
            }


            //   $return_urls[] = $repo_conf;


        }
        return $urls;
        //  return $return_urls;

    }


    public function write_report_file()
    {
        $this->say('Writing report to: ' . $this->report_file);


        file_put_contents($this->report_file, json_encode($this->report_data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

    }


    public function mocha()
    {
        $this->say('Reading report from: ' . $this->report_file);

        $report_raw = @json_decode(@file_get_contents($this->report_file), true);
        if (!$report_raw) {
            $this->say('Cannot read from: ' . $this->report_file);
            dd('mocha_fail');
        }
        $filter = array();

        foreach ($report_raw as $k1 => $report_folder) {
            foreach ($report_folder as $k2 => $report_branch) {
                if (isset($report_branch['config']['ui_test']) and $report_branch['config']['ui_test']) {
                    $filter[$k1 . '/' . $k2] = $report_branch;
                }
//                'branch' => $branch,
//                            'folder' => $folder,
//                            'link' => $out_folder2,
//                            'compare_link' => $out_folder,
//


            }
        }
        dd($filter);

    }

    function chmod_templates_folder()
    {
        $chmod_dir = $this->workdir . DIRECTORY_SEPARATOR . 'userfiles/templates/';
        $this->_exec('chmod -Rv 755 ' . $chmod_dir);

    }

    public function check_for_anomalies()
    {
        d('FIXME: check_for_anomalies is disabled at ' . __FILE__ . __LINE__);
        return;
        // <<<<<<< HEAD
        //  $this->chmod_templates_folder();
// grep --include=\*.{c,h} -rnw '/path/to/somewhere/' -e "pattern"
// grep --exclude-dir={dir1,dir2,*.dst} -rnw '/path/to/somewhere/' -e "pattern"
// grep --exclude-dir={dir1,dir2,*.dst} -rnw '/path/to/somewhere/' -e "<<<<<<< HEAD"

        $wd = $this->workdir;
        $cmd = "grep --exclude-dir={.git,.svn,*.dst} -rnw '{$wd}' -e \"<<<<<<< HEAD\"";

        $exec = shell_exec($cmd);
        if ($exec) {
            $heads = explode('HEAD', $exec);
            if (count($heads) > 1) {
                dd('ERROR: <<<<<<< HEAD ', $exec);
            }
        }


    }


    public function check_folder_for_syntax_errors($folder)
    {
        return;
        $cmd = "cd {$folder} && phplint '**/*.php' '!vendor/**'";
        $exec = shell_exec($cmd);

        $this->say('phplint');
        if ($this->taskExec($exec)->run()->wasSuccessful()) {
            $this->say('phplint was successful');
        } else {
            $this->say('phplint error');
            dd('ERROR: ', $exec);

        }
    }


    private function _ccopydir($from_folder, $to_folder)
    {

        $this->taskDeleteDir($to_folder)->run();


        if (!is_dir($to_folder)) {
            mkdir_recursive($to_folder);
        }

        $this->taskCopyDir([$from_folder => $to_folder])->run();


    }

    private function _mw_make_install($install_folder)
    {
        if (is_file($install_folder . '.env') and is_file($install_folder . '.env.example')) {
            unlink($install_folder . '.env');
            copy($install_folder . '.env.example', $install_folder . '.env');
        }

        $exec = "cd " . $install_folder . ' &&  ';
        $exec .= "php artisan microweber:install ";
        $contact_email = 'admin@localhost';
        $auth_user = 'admin';
        $auth_pass = 'pass';
        $database_host = '127.0.0.1';
        $sqlite_file = 'storage/database.sqlite';
        $database_user = 'db_user';
        $database_password = 'db_pass';
        $database_prefix = 'mw_';
        $default_template = 'liteness';
        $domain = 'localhost';
        $exec .= $contact_email . " " . $auth_user . " " . $auth_pass . " " . $database_host . " " . $sqlite_file . " " . $database_user . " " . $database_password . " sqlite -p " . $database_prefix;
        if (isset($prepare_only) and $prepare_only) {
            $exec .= " -c 1"; //
        }
        $exec .= " -t " . $default_template . " -d 1 --env={$domain}";

        $this->say('Installing');
        if ($this->taskExec($exec)->run()->wasSuccessful()) {
            $this->say('Installing was successful');
        } else {
            $this->say('Install error');
            dd('ERROR: ', $exec);

        }
    }
}


class ExceptionTask extends \Robo\Task\BaseTask
{
    protected $message;

    public function __construct($message)
    {
        $this->message = $message;
    }

    public function run()
    {
        throw new RuntimeException($this->message);
    }
}






